<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Checks extends Admin_Controller
{

	function __construct()
	{
		parent::__construct();
	}

	public function index()
	{
		$checks = $this->db->query("SELECT * FROM `customer_invoices_payments_items` WHERE `payment_type` = 5 AND `is_canceled` = 0 ")->result();
		$supplires = $this->db->query("SELECT `supplier_id`, `name` FROM `suppliers`")->result();
		$payment_boxes  = reindex_by_key($this->db->query("SELECT * FROM `customer_invoices_boxes`")->result(), 'box_id');
        $payment_types  = reindex_by_key($this->db->query("SELECT * FROM `customer_invoices_payments_type`")->result(), 'type_id');

		$this->template
			->set('view', 'admin/checks/index')
			->set('checks', $checks)
			->set('supplires', $supplires)
			->set('payment_types', $payment_types)
			->set('payment_boxes', $payment_boxes)

			->render();
	}
	public function checkReturn()
	{
		$data = $_POST;
		// debug($_POST);
		if (isset($_POST['checkArray']) && !empty($_POST['checkArray'])) {
			for ($i = 0; $i < count($_POST['checkArray']); $i++) {
				$item_id = $data['checkArray'][$i];
				$check_data = $this->db->query("SELECT * FROM `customer_invoices_payments_items` WHERE `item_id` = $item_id")->row();
				if (!empty($check_data) && $check_data->check_return == 0) {
					$update_data = array(
						'check_return'    => 1,
						'is_canceled'     => 1
					);
					$updatrow = $this->general_model->updateRowById('customer_invoices_payments_items', 'item_id', $check_data->item_id, $update_data);
					$logData = array(
						'userId	'     => getUserId(),
						'type'        => "customer_payment+item",
						'type_id'     =>$check_data->item_id,
						'action'      => "cancel_check_payment",
						'befor'       => "payment",
						'after'       => "canceled payment by check",
						'action_date' => date('Y-m-d H:i:s'),
					);
					$log_id = $this->general_model->insertRow('activities_log', $logData);
					$revers_total = $check_data->total * -1;
					$payment_items = array(
						'payment_id'     => $check_data->payment_id,
						'customerId'     => $check_data->customerId,
						'payment_type'   => $check_data->payment_type,
						'payment_box'    => $check_data->payment_box,
						'total'          => $revers_total,
						'check_number'   => $check_data->check_number,
						'check_date'     => $check_data->check_date,
						'bank_visa'      => $check_data->bank_visa,
						'branch_digits'  => $check_data->branch_digits,
						'account_card'   => $check_data->account_card,
						'reference_id'   => $check_data->reference_id,
						'check_used_for' => $check_data->check_used_for,
						'payment_date'   => $check_data->payment_date,
						'check_return'   => 1,
						'check_used'     => 1,
						'dateCreation'   => date('Y-m-d H:i:s'),
						'lastUpdate'     => date('Y-m-d H:i:s'),
					);
					$addedItems = $this->general_model->insertRow('customer_invoices_payments_items', $payment_items);
					$logData = array(
						'userId	'     => getUserId(),
						'type'        => "customer_payment_item",
						'type_id'     =>$addedItems,
						'action'      => "reverse_check_customer_payment",
						'befor'       => "customer_check_payment",
						'after'       => "add reverse check payment",
						'action_date' => date('Y-m-d H:i:s'),
					);
					$log_id = $this->general_model->insertRow('activities_log', $logData);
					if ($check_data->check_used  == 1) {
						$supplier_payment_items = array(
							'payment_id'        => $check_data->payment_id,
							'supplier_id'       => $check_data->check_used_for,
							'payment_method'    => $check_data->payment_type,
							'box'               => $check_data->payment_box,
							'payment_total'     => $check_data->total,
							'check_number'      => $check_data->check_number,
							'check_date'        => $check_data->check_date,
							'bank_visa'         => $check_data->bank_visa,
							'Branch_digits'     => $check_data->branch_digits,
							'account_date'      => $check_data->account_card,
							'reference_number'  => $check_data->reference_id,
							'payment_date'      => $check_data->payment_date,
							'check_return'      => 1,
							'dateCreation'      => date('Y-m-d H:i:s'),
							'lastUpdate'        => date('Y-m-d H:i:s'),
						);
						$addedItems = $this->general_model->insertRow('supplier_payments_items', $supplier_payment_items);
						$logData = array(
							'userId	'     => getUserId(),
							'type'        => "supplier_payments_items",
							'type_id'     => $addedItems,
							'action'      => "reverse_check_supplier_payment",
							'befor'       => "check payment",
							'after'       => "add reverse check payment",
							'action_date' => date('Y-m-d H:i:s'),
						);
						$log_id = $this->general_model->insertRow('activities_log', $logData);
					}
				}
			}
			echo json_encode(array("result" => true));
		} else {
			echo json_encode(array("result" => false, "message" => "No Invoice selected"));
		}
	}
	public function getItems(){
		$checks = array();
		
		if (isset($_POST['checkArray']) && !empty($_POST['checkArray'])) {
			$items = implode(",", $_POST['checkArray']);
			$checks = $this->db->query("SELECT * FROM `customer_invoices_payments_items` WHERE `item_id` IN ($items) ")->result();
			foreach( $checks as $check ){
				$check->paymentTypeName = getPaymentMethod($check->payment_type);
				$check->paymetnBoxName = getPaymentBox($check->payment_box);
				$check->bankName = getBankName($check->bank_visa);
				$check->branchName = getBranchName($check->bank_visa, $check->branch_digits);
			}
		}
		echo json_encode(array('result' => true, "data" => $checks));
	}
}
