<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

if ( !function_exists('uploadFile')) {
    function uploadFile ($path, $inputName, $fileType) {
        $CI = & get_instance();
        $config['upload_path'] = './assets/'.$path;
        $config['allowed_types'] = $fileType;
        $config['max_size']  = '300';
        $CI->load->library('upload', $config);
    
        if (!$CI->upload->do_upload($inputName)) {
            //return $CI->upload->display_errors();
            return false;
        } else {
            return $CI->upload->data();
        }      
    }  
}

if ( !function_exists('deleteFile')) {
    function deleteFile ($path, $fileName) {
        $CI = & get_instance();
        $config['file_path'] = './assets/'.$path;
        if (file_exists($config['file_path'].'/'.$fileName)) {
            $result = unlink($config['file_path'].'/'.$fileName);
            if ($result) {
                return true;
            } else {
                return false;
            }
        } else {
            return array('result'=>false, 'msg'=>'File does not exist');
        }
    }
}

if ( !function_exists('resizeImage')) {
    function resizeImage ($path, $imageName, $width, $height) {
        $CI = & get_instance();
        $config['image_library'] = 'gd2';
        $config['source_image']    = './assets/'.$path.'/'.$imageName;
        $config['new_image'] = './assets/'.$path.'/resized_'.$imageName;
        $config['maintain_ratio'] = TRUE;
        $config['width'] = $width;
        $config['height'] = $height;
       
        $CI->load->library('image_lib', $config);
        
        return $CI->image_lib->resize();
    }
}

if ( !function_exists('resizeImageToLW')) {
    function resizeImageToLW ($path, $imageName) {
        
        $CI = & get_instance();
        $imageSize = getimagesize('./assets/'.$path.'/'.$imageName);
        
        var_dump($imageSize);
        
        $config['image_library'] = 'gd2';
        $config['source_image']    = './assets/'.$path.'/'.$imageName;
        $config['new_image'] = './assets/'.$path.'/resized_lw_'.$imageName;
        $config['maintain_ratio'] = TRUE;
        $config['width'] = $imageSize[0] * 0.9;
        $config['height'] = $imageSize[1] * 0.9;
       
        $CI->load->library('image_lib', $config);
       
        return $CI->image_lib->resize();
    }
}