<script src="<?php echo site_url(); ?>assets/js/plugin/datatables1_10_7/jquery.dataTables.min.js"></script>
<script src="<?php echo site_url(); ?>assets/js/plugin/datatables/dataTables.colReorder.min.js"></script>
<script src="<?php echo site_url(); ?>assets/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="<?php echo site_url(); ?>assets/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="<?php echo site_url(); ?>assets/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="<?php echo site_url(); ?>assets/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>
<link href="https://www.callup2.co/assets/css/print.css" rel="stylesheet" media="print" />
<style>
	body {
		background: rgb(204, 204, 204);
	}

	page {
		background: white;
		display: block;
		margin: 0 auto;
		margin-bottom: 0.5cm;
		box-shadow: 0 0 0.5cm rgba(0, 0, 0, 0.5);
	}

	page[size="A4"] {
		width: 21cm;
		height: 29.7cm;
		padding: 25px;
		padding-top: 20px;
	}

	.col {
		text-align: center;
	}

	table.table.table-condensed tr td:nth-child(2) {
		font-weight: bold;
	}

	table.table.table-condensed td {
		border-top: 0px !Important;
		padding: 0px;
	}

	#invoice_table {
		text-align: right;
	}

	#invoice_table tfoot td:nth-child(2) {
		text-align: left;
		font-weight: bold;
	}

	#invoice_table tfoot td:nth-child(3) {
		font-weight: bold;
	}

	#invoice_table tfoot tr:nth-last-child(1) td:nth-child(3),
	#invoice_table tfoot tr:nth-last-child(1) td:nth-child(2) {
		background: #f1f1f1;
	}

	#invoice_table,
	#payment_table {
		border: 1px solid #dedede;
		text-align: right !important;
	}

	#payment_table tfoot {
		font-weight: bold;
	}

	#payment_table tfoot tr td:nth-child(3),
	#payment_table tfoot tr td:nth-child(2) {
		background: #f1f1f1;
	}
</style>
<!-- MAIN PANEL -->
<div id="main" role="main">

	<!-- MAIN CONTENT -->
	<div id="content">
		<page size="A4">
			<div class="row">
				<div class="col col-lg-12 col-md-12 col-sm-12">
					<h2>
							<?php echo $this->lang->line('invoicing_supplier_tax'); ?>
							<?php echo $invoice->invoice_id; ?>
					</h2>
				</div>
				<div class="col-lg-6 col-md-6 col-sm-12" id="customer_details">
					<table class="table table-condensed">
						<tbody>
								<?php $supplierData = getSupplierData($invoice->supplier_id); ?>
								<tr>
									<td>
										<?php echo $this->lang->line('send_to'); ?>
										<strong><?php echo getSupplierName($invoice->supplier_id); ?></strong>
									</td>
								</tr>
								<tr>
									<td><?php echo $supplierData->phone_number; ?></td>
								</tr>
								<tr>
									<td><?php echo $supplierData->vat_number; ?></td>
								</tr>
								<tr>
									<td><?php echo $supplierData->email; ?></td>
								</tr>
								<tr>
									<td><?php echo $supplierData->address; ?></td>
								</tr>
						</tbody>
					</table>
				</div>
				<div class="col-lg-6 col-md-6 col-sm-12" id="main_invoice_details">
					<table class="table table-condensed">
						<tbody>
								<tr>
									<td><?php echo $this->lang->line('copy_source'); ?></td>
								</tr>
							<tr>
								<td><?php echo $this->lang->line('date'); ?></td>
								<td><?php echo date('d/m/Y', strtotime($invoice->invoice_date)); ?></td>
							</tr>
								<tr>
									<td><?php echo $this->lang->line('supplier_number'); ?></td>
									<td><?php echo $supplierData->supplier_id; ?></td>
								</tr>
								<tr>
									<td><?php echo $this->lang->line('number_deals'); ?></td>
									<td><?php echo $supplierData->vat_number; ?></td>
								</tr>
						</tbody>
					</table>
				</div>
				<div class="col col-lg-12 col-md-12 col-sm-12" id="invoice_details">
					<table class="table" id="invoice_table">
						<thead>
							<tr>
								<th colspan="2" style=" width: 200px; "><?php echo $this->lang->line('description'); ?></th>
								<th></th>
								<th><?php echo $this->lang->line('unit'); ?></th>
								<th><?php echo $this->lang->line('unit_price'); ?></th>
								<th><?php echo $this->lang->line('total'); ?></th>
							</tr>
						</thead>
						<tbody>
							<?php $total_before_vat = 0; ?>
							<?php foreach ($invoice_items as $item) { ?>
								<tr>
									<td colspan="2">
										<?php echo $item->item_title; ?>
									</td>
									<td></td>
									<td>
										<?php echo $item->unit; ?>
									</td>
									<td>
										<?php echo $item->item_price; ?>
									</td>
									<td>
										<?php echo number_format($item->unit * $item->item_price, 2); ?>
									</td>
								</tr>
								<?php $total_before_vat = $total_before_vat + ($item->unit * $item->item_price); ?>
							<?php }; ?>
						</tbody>
						<tfoot>
							<tr>
								<td colspan="3"></td>
								<td colspan="2"><?php echo $this->lang->line('total_before_vat'); ?></td>
								<td><?php echo number_format($total_before_vat, 2); ?></td>
							</tr>
							<tr>
								<td colspan="3"></td>
								<td colspan="2"><?php echo $this->lang->line('vat_17'); ?></td>
								<td>
									<?php $vat = round($total_before_vat * 0.17, 2); ?>
									<?php echo number_format($vat, 2); ?>
								</td>
							</tr>
							<tr>
								<td colspan="3"></td>
								<td colspan="2"><?php echo $this->lang->line('total_shekel'); ?></td>
								<td>
									<?php $total = $vat + $total_before_vat; ?>
									<?php echo number_format($total, 2); ?>
								</td>
							</tr>
						</tfoot>
					</table>
				</div>
				<?php if (!empty($payments) && $invoice->invoice_type == 1) { ?>
					<div class="col col-lg-12 col-md-12 col-sm-12" id="payments_details">
						<table class="table" id="payment_table">
							<thead>
								<th><?php echo $this->lang->line('cashbox'); ?></th>
								<th><?php echo $this->lang->line('payment_method'); ?></th>
								<th><?php echo $this->lang->line('date_maturity'); ?></th>
								<th><?php echo $this->lang->line('date'); ?></th>
								<th><?php echo $this->lang->line('branch_4digits'); ?></th>
								<th><?php echo $this->lang->line('account_validity'); ?></th>
								<th><?php echo $this->lang->line('reference_id'); ?></th>
								<th><?php echo $this->lang->line('total'); ?></th>
							</thead>
							<tbody>
								<?php $full_payment_total = 0; ?>
								<?php foreach ($payments as $payment) { ?>
									<tr>
										<td><?php echo $payment_boxes[$payment->payment_box]->name; ?></td>
										<td><?php echo $payment_types[$payment->payment_type]->name; ?></td>
										<td><?php echo date('d/m/Y', strtotime($payment->payment_date)); ?></td>
										<td><?php echo $payment->bank_visa; ?></td>
										<td><?php echo $payment->branch_digits; ?></td>
										<td><?php echo $payment->account_card; ?></td>
										<td><?php echo $payment->reference_id; ?></td>
										<td><?php echo number_format($payment->total, 2); ?></td>
									</tr>
									<?php $full_payment_total = $full_payment_total + $payment->total; ?>
								<?php }; ?>
							</tbody>
							<tfoot>
								<tr>
									<td colspan="5"></td>
									<td colspan="2"><?php echo $this->lang->line('total_receipt_shekel'); ?></td>
									<td><?php echo number_format($full_payment_total, 2); ?></td>
								</tr>
							</tfoot>
						</table>
					</div>
				<?php }; ?>
			</div>
		</page>
	</div>

</div>

<style>
	#customer_details .table tr td:empty {
		display: none;
	}
</style>