<div id="main" role="main">

<style>
    body {
        background: rgb(204,204,204); 
    }
    page {
        background: white;
        display: block;
        margin: 0 auto;
        margin-bottom: 0.5cm;
        box-shadow: 0 0 0.5cm rgba(0,0,0,0.5);
    }
    page[size="A4"] {  
        width: 21cm;
        height: 29.7cm;
        padding:25px;
        padding-top:20px;
    }
    .col{
        text-align:center;
    }
    
    table.table.table-condensed tr td:nth-child(2) {
        font-weight: bold;
    }
    
    table.table.table-condensed td {
        border-top: 0px !Important;
        padding: 0px;
    }
    
    #invoice_table {
        text-align: right;
    }
    
    #invoice_table tfoot td:nth-child(2) {
        text-align: left;
        font-weight: bold;
    }
    
    #invoice_table tfoot td:nth-child(3) {
        font-weight: bold;
    }
    
    #invoice_table tfoot tr:nth-last-child(1) td:nth-child(3),
    #invoice_table tfoot tr:nth-last-child(1) td:nth-child(2) {
        background: #f1f1f1;
    }
    
    #invoice_table, #payment_table{
        border: 1px solid #dedede;
        text-align: right !important;
    }
    
    #payment_table tfoot {
        font-weight: bold;
    }
    
    #payment_table tfoot tr td:nth-child(3),
    #payment_table tfoot tr td:nth-child(2) {
        background: #f1f1f1;
    }

</style>

        <div id="content">
            <page size="A4">
                <div class="row">
                    <div class="col col-lg-12 col-md-12 col-sm-12">
                        <h2>
                        <?php echo $this->lang->line('order_num'); ?>
                            <?php echo $order->id ?>
                        </h2>
                    </div>
                    <div class="col-lg-6 col-md-6 col-sm-12" id="customer_details">
                        <table class="table table-condensed">
                            <tbody>

                                <tr>
                                    <td>
                                    <?php echo $this->lang->line('send_to'); ?>
                                        <strong><?php echo $customer->customerName; ?></strong>
                                    </td>
                                </tr>
                                <tr>
                                    <td><?php echo $customer->phoneNumber; ?></td>
                                </tr>
                                <tr>
                                    <td><?php echo $customer->email; ?></td>
                                </tr>
                                <tr>
                                    <td><?php echo $customer->address; ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="col-lg-6 col-md-6 col-sm-12" id="main_invoice_details">
                        <table class="table table-condensed">
                            <tbody>
                                <tr>
                                    <td colspan="2"><?php echo $this->lang->line('copy_source'); ?></td>
                                </tr>

                                <tr>
                                    <td><?php echo $this->lang->line('date'); ?></td>
                                    <td><?php echo date('d/m/Y', strtotime($order->order_date)); ?></td>
                                </tr>
                                    <tr>
                                        <td><?php echo $this->lang->line('customer_number'); ?></td>
                                        <td><?php echo $customer->customerId; ?></td>
                                    </tr>
                                    <tr>
                                        <td><?php echo $this->lang->line('number_deals'); ?></td>
                                        <td><?php echo $customer->invID; ?></td>
                                    </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="col col-lg-12 col-md-12 col-sm-12" id="invoice_details">
                        <table class="table" id="invoice_table">
                            <thead>
                                <tr>
                                    <th colspan="2" style=" width: 200px; "><?php echo $this->lang->line('description'); ?></th>
                                    <th></th>
                                    <th><?php echo $this->lang->line('unit'); ?></th>
                                    <th><?php echo $this->lang->line('unit_price'); ?></th>
                                    <th><?php echo $this->lang->line('discount'); ?></th>
                                    <th><?php echo $this->lang->line('total'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $total_before_vat = 0; ?>
                                <?php foreach ($order_items as $item) { ?>
                                    <tr>
                                        <td colspan="2">
                                            <?php echo $item->item_name; ?>
                                        </td>
                                        <td></td>
                                        <td>
                                            <?php echo $item->unit; ?>
                                        </td>
                                        <td>
                                            <?php echo $item->price; ?>
                                        </td>
                                        <td><?php echo $item->discount; ?></td>
                                        <td>
                                            <?php echo number_format($item->unit * ($item->price - ($item->price * ($item->discount/100))) , 2); ?>
                                        </td>
                                    </tr>
                                    <?php $total_before_vat = $total_before_vat + ($item->unit * ($item->price - ($item->price * ($item->discount/100)))); ?>
                                <?php }; ?>
                            </tbody>
                            <tfoot>
                            <tr>
                                    <td colspan="4"></td>
                                    <td colspan="2"><?php echo $this->lang->line('discount'); ?></td>
                                    <td><?php echo number_format($item->discount, 2); ?></td>
                                </tr>
                                <tr>
                                    <td colspan="4"></td>
                                    <td colspan="2"><?php echo $this->lang->line('total_before_vat'); ?></td>
                                    <td><?php echo number_format($total_before_vat, 2); ?></td>
                                </tr>
                                <tr>
                                    <td colspan="4"></td>
                                    <td colspan="2"><?php echo $this->lang->line('vat_17'); ?></td>
                                    <td>
                                        <?php $vat = round($total_before_vat * 0.17, 2); ?>
                                        <?php echo number_format($vat, 2); ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="4"></td>
                                    <td colspan="2"><?php echo $this->lang->line('total_shekel'); ?></td>
                                    <td>
                                        <?php $total = $vat + $total_before_vat; ?>
                                        <?php echo number_format($total, 2); ?>
                                    </td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                  
                </div>
            </page>
        </div>


    
</div>