<script src="<?php echo site_url(); ?>assets/js/plugin/datatables1_10_7/jquery.dataTables.min.js"></script>
<script src="<?php echo site_url(); ?>assets/js/plugin/datatables/dataTables.colReorder.min.js"></script>
<script src="<?php echo site_url(); ?>assets/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="<?php echo site_url(); ?>assets/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="<?php echo site_url(); ?>assets/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="<?php echo site_url(); ?>assets/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>

<script src="//cdn.datatables.net/buttons/1.6.1/js/dataTables.buttons.min.js" crossorigin="anonymous"></script>
<script src="//cdn.datatables.net/buttons/1.6.1/js/buttons.flash.min.js" crossorigin="anonymous"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js" crossorigin="anonymous"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js" crossorigin="anonymous"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js" crossorigin="anonymous"></script>
<script src="//cdn.datatables.net/buttons/1.6.1/js/buttons.html5.min.js" crossorigin="anonymous"></script>
<script src="//cdn.datatables.net/buttons/1.6.1/js/buttons.print.min.js" crossorigin="anonymous"></script>
<script src="//cdn.datatables.net/buttons/1.6.1/js/buttons.colVis.min.js" crossorigin="anonymous"></script>

<div id="main" role="main">
    <div id="content">
        <div class="row">
            <div class="col-xs-12 col-sm-10 col-md-10 col-lg-10">
                <h1 class="page-title txt-color-blueDark m-0">
                    <i class="fa fa-user fa-fw "></i>
                    <?php echo $this->lang->line('users'); ?>
                    <span>
                        <?php echo $this->lang->line('users'); ?>
                    </span>
                </h1>
            </div>
            <div class="col-xs-12 col-sm-2 col-md-2 col-lg-2">
                <a class="btn btn-primary pull-right header-btn hidden-mobile" href="<?php print site_url(); ?>admin/users/userForm" title="<?php echo $this->lang->line('new_user');?>"><i class="fa fa-user"></i> <?php echo $this->lang->line('new_user'); ?></a>
            </div>
        </div>
        <?php if ($this->session->flashdata('flashMsgType') == 'Success') : ?>
            <div class="alert alert-success fade in"><button class="close" data-dismiss="alert">×</button><i class="fa-fw fa fa-check"></i>
                <strong><?php print $this->session->flashdata('flashMsgType') ?></strong> <?php print $this->session->flashdata('flashMsg') ?>
            </div>
        <?php elseif ($this->session->flashdata('flashMsgType') == 'Error') : ?>
            <div class="alert alert-danger fade in"><button class="close" data-dismiss="alert">×</button><i class="fa-fw fa fa-times"></i>
                <strong><?php print $this->session->flashdata('flashMsgType') ?></strong> <?php print $this->session->flashdata('flashMsg') ?>
            </div>
        <?php endif; ?>
        <section id="widget-grid" class="">
            <div class="row">
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                    <h2><?php echo $this->lang->line('all_users'); ?></h2>
                    <div class="card card-body">
                        <div class="table-responsive">
                            <table id="NewUsersTable" class="table table-striped table-bordered table-hover">
                                <thead>
                                    <th>#</th>
                                    <th><?php echo $this->lang->line('type'); ?></th>
                                    <th><?php echo $this->lang->line('name'); ?></th>
                                    <th><?php echo $this->lang->line('telephone'); ?></th>
                                    <th><?php echo $this->lang->line('mail'); ?></th>
                                    <th><?php echo $this->lang->line('active'); ?></th>
                                    <th><?php echo $this->lang->line('recording'); ?></th>
                                </thead>
                                <tbody>
                                    <?php foreach ($users as $u) :
                                        switch ($u->userLevel) {
                                            case 1:
                                                $t = $this->lang->line('admin_system');
                                                break;
                                            case 2:
                                                $t = $this->lang->line('admiring');
                                                break;
                                        } ?>
                                        <tr class="userRow" rel="<?php print $u->userId ?>">
                                            <td><?php print $u->userId ?></td>
                                            <td><?php print '<span class="label status" style="width: auto; text-align: center; font-weight: bold; color: #fff; background-color: #e63232; padding: 1px 6px; float: right; margin: 0 2px;">' . $t . '</span>'; ?></td>
                                            <td><?php print $u->firstname . ' ' . $u->lastname ?></td>
                                            <td><?php print $u->phone ?></td>
                                            <td><?php print $u->email ?></td>
                                            <td>
                                                <?php if ($u->isActive) : ?>
                                                    <span class="label label-success"><?php echo $this->lang->line('active'); ?></span>
                                                <?php else : ?>
                                                    <span class="label label-danger"><?php echo $this->lang->line('not_active'); ?></span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php print date('d/m/Y', strtotime($u->creationDate)) ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                    <?php foreach ($users2 as $u2) :
                                        switch ($u2->userLevel) {
                                            case 1:
                                                $t = $this->lang->line('admin_system');
                                                break;
                                            case 2:
                                                $t = $this->lang->line('admiring');
                                                break;
                                        } ?>

                                        <tr class="userRow" rel="<?php print $u2->userId ?>">
                                            <td><?php print $u2->userId ?></td>
                                            <td><?php print '<span class="label status" style="width: auto; text-align: center; font-weight: bold; color: #fff; background-color: #e63232; padding: 1px 6px; float: right; margin: 0 2px;">' . $t . '</span>'; ?></td>
                                            <td><?php print $u2->firstname . ' ' . $u2->lastname ?></td>
                                            <td><?php print $u2->phone ?></td>
                                            <td><?php print $u2->email ?></td>
                                            <td>
                                                <?php if ($u2) : ?>
                                                    <span class="label label-success"><?php echo $this->lang->line('active'); ?></span>
                                                <?php else : ?>
                                                    <span class="label label-danger"><?php echo $this->lang->line('not_active'); ?></span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php print date('d/m/Y', strtotime($u2->creationDate)) ?></td>
                                        </tr>

                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </article>
            </div>
    </div>
    </section>
</div>
</div>

<style>
    .dt-buttons {
        float: left;
        text-align: right;
    }

    .dt-button {
        background: transparent;
        border: 1px solid #a90329;
        padding: 5px;
        padding-right: 20px;
        padding-left: 20px;
        font-weight: bold;
        border-radius: 25px;
        color: #a90329;
    }

    .dt-button-collection .dt-button {
        background: #ffffff;
        float: right;
        opacity: 0.5;
    }

    .dt-button-collection {
        margin-top: 7px;
        position: absolute;
        z-index: 9999;
        background: #0000007a;
        width: 140%;
        right: 100px;
        padding: 7px;
        border-radius: 25px;
    }

    button.dt-button.buttons-columnVisibility.active {
        background: white;
        opacity: 1;
    }
</style>

<script>
    $(document).ready(function() {
        <?php
            $url = '';
            if( $this->session->userdata('site_lang') == 'hebrew' ){
                $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Hebrew.json';
            }else if( $this->session->userdata('site_lang') == 'arabic' ){
                $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Arabic.json';
            }else if( $this->session->userdata('site_lang') == 'english' ){
                $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json';
            }else{
                $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Hebrew.json';
            }
        ?>
        var oTbl1 = $('#NewUsersTable').DataTable({
            "sDom": "<'dt-toolbar'<'col-xs-12 col-sm-8'f><'dt-buttons col-sm-4 col-xs-12 hidden-xs'l>r>" +
                "t" +
                "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-xs-12 col-sm-6'p>>",
            "buttons": ['excelHtml5'],
            "dom": 'Blfrtip',
            "pagingType": "full_numbers",
            "lengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "<?php echo $this->lang->line('Everything'); ?>"]
            ],
            "pageLength": 10,
            "sPaginationType": "full_numbers",
            "iDisplayLength": 10,
            "scrollX": true,
            "language": {
                    "url": "<?php echo $url; ?>"
                },

            orderCellsTop: true,
            fixedHeader: true
        });
        oTbl1.buttons().container().appendTo('.dataTables_filter');
        $('input[aria-controls="NewUsersTable"]').attr('placeholder', '<?php echo $this->lang->line('search1'); ?>...');
        $('.dataTables_paginate ').parent().css('float', 'right');
        $('.dataTables_paginate ').css('text-align', 'right');
        $(document).on('click', '.userRow', function() {
            var id = $(this).attr('rel');
            window.location.href = window.location + '/userForm/' + id;
        });
    });
</script>
<style>
    .userRow {
        cursor: pointer;
    }
</style>
<style>
    table#NewUsersTable {
        width: 100% !important;
    }
</style>