$(document).ready(function() {
    
        var $orderForm = $("#lead-form").validate({
		// Rules for form validation
		rules : {
			firstname : {
				required : true
			},
            lastname : {
				required : true
			},
			email : {
				required : true,
				email : true
			},
			phone : {
				required : true
			},
            
		},

		// Messages for form validation
		messages : {
			firstname : {
				required : 'Please enter user first name'
			},
            lastname : {
				required : 'Please enter user last name'
			},
			email : {
				required : 'Please enter your email address',
				email : 'Please enter a VALID email address'
			},
            phone : {
				required : 'Please enter your phone number'
			},
            
		},

		// Do not change code below
		errorPlacement : function(error, element) {
			error.insertAfter(element.parent());
		}
	});
     
});


function leadToCustomer(leadId) {
    $("#dialog_editDelivery").dialog({
		autoOpen : false,
		width : 300,
		resizable : true,
		modal : true,
		title : "<div class='widget-header'><h4><i class='fa fa-edit'></i> שיוך פניה ללקוח</h4></div>",        
        buttons : [{
			html : "<i class='fa fa-edit'></i>&nbsp; שמירה",
			"class" : "btn btn-success",
			click : function() {
                if($('#customerSelect').val() == 'בחר לקוח') {
                    $('#customerSelect').parent().addClass('has-error');
                    return false;    
                } else {
                    $('#customerSelect').parent().removeClass('has-error');
                    var data = {};
                    data.customerId = $('#customerSelect').val();
                    data.leadId = leadId;
                    $.post(root + 'admin/leads/addLeadToCustomer/', { 'data': data }, function(d) {
                        if(d.result){
                            window.location.href = root + 'admin/leads';
                        }
                        if(!d.result) alert('פניה זו כבר משויכת ללקוח!');
                    }, 'json');
                    $(this).dialog("close");
                }   
			}
		}, {
			html : "<i class='fa fa-times'></i>&nbsp; ביטול",
			"class" : "btn btn-default",
			click : function() {
			    //$('.deliveryRow[rel="' + id + '"]').removeClass('highlightTD'); 
				$(this).dialog("close");
			}
		}]
	});
    $('.ui-dialog-content').html($('#editDeliveryForm'));        
    $("#dialog_editDelivery").dialog('open');
}
;