<?php

class customers_model extends CI_Model {

    function __construct() {
        parent::__construct();
    }
    
    function getCustomers($isActive = true) {
        $this->db->select('c.*, ut.title');
        $this->db->from('customers c');
        $query = $this->db->get();
        
		return $query->result();
	}
    
    function getCustomersByOwner($isActive = true, $ownerId = 0) {
        $this->db->select('c.*');
        $this->db->from('customers c');
        $this->db->where('c.adminId', $ownerId);
        $query = $this->db->get();
        
		return $query->result();
	}
    
    function getCustomerById($customerId, $isActive = true) {
        $this->db->select('*');
        $this->db->from('customers');
        $this->db->where('customerId', $customerId);
        //$this->db->where('IsActive', $isActive);
        $query = $this->db->get();
        
		return $query->result();
	}
     
    function getCustomerRelatedLeads($customerId) {
		$this->db->select('l.*, lc.*');
		$this->db->from('leads_customers lc');
        $this->db->join('customers c', 'lc.customerId = c.customerId', 'inner');
        $this->db->join('leads l', 'lc.leadId = l.leadId', 'inner');
        $this->db->where('lc.customerId', $customerId);
        $this->db->where('lc.isActive', '1');
        $this->db->order_by('lc.creationDate', 'DESC');
        
        $query = $this->db->get();
        
		return $query->result();
	}
    
    function getLatestNews($limit = NULL, $isActive = true) {
        $this->db->select('*');
        $this->db->from('news');
        $this->db->order_by('LastUpdate', 'desc');
        $this->db->where('IsActive', $isActive);
        if($limit != NULL) {
            $this->db->limit($limit);
        }
        $query = $this->db->get();
        
		return $query->result();
        
    }
    
 }