<?php
if (
    !isset($permissions['finance']['invoices'])
    || isset($permissions['finance']['invoices'])
    && $permissions['finance']['invoices'] == 0
) redirect('admin/dashboard');

?>
<script src="https://cdn.lordicon.com/libs/mssddfmo/lord-icon-2.1.0.js"></script>
<div id="main p-0" role="main">
    <!-- <div class="header-bg shadow-sm p-0" style="background: url(https://images.pexels.com/photos/1475033/pexels-photo-1475033.jpeg?auto=compress&cs=tinysrgb&dpr=2&h=750&w=1260)"> -->
    <!-- <div class="header-bg shadow-lg p-0" style="background: url(https://images.pexels.com/photos/1487834/pexels-photo-1487834.jpeg?auto=compress&cs=tinysrgb&dpr=2&h=750&w=1260)"></div> -->
    <div id="content" style=" padding-top: 0px; ">
        <div class="container">
            <div class="row mt-3 justify-content-center">
                <div class="header_invoice_wrapper shadow">
                    <div class="fs-1 w-25 text-white d-flex align-items-center">
                        <?php echo $this->lang->line('customer'); ?>
                    </div>
                    <div class="new_invoice_btn">
                        <a type="button" class="shadow-lg add_invoice_button" href="<?php echo site_url(); ?>admin/customers/customerForm/" target="_blank" title="<?php echo $this->lang->line('new_customer'); ?>">
                            <lord-icon src="https://cdn.lordicon.com/mecwbjnp.json" trigger="loop" delay="1000" colors="primary:#356359,secondary:#00bcd4" style="width:32px;height:32px">
                            </lord-icon>
                            <span class="pt-1 text-dark">
                                <?php echo $this->lang->line('new_customer'); ?>
                            </span>
                        </a>
                        <button type="button" class="shadow-lg excel_exporter cancel_invoice p-2" style="width: 50px;" data-bs-toggle="modal" id="deleteInvoiceButton" rel-invoice="-1" data-bs-target="#DeleteInvoice">
                            <i class="me-1 fas fa-lock text-danger"></i>
                        </button>
                        <button type="button" class="shadow-lg excel_exporter view_invoice p-2" style="width: 50px;" data-bs-toggle="modal" id="viewInvoiceButton" rel-invoice="-1" data-bs-target="#DeleteInvoice">
                            <i class="pt-1 me-1 fas fa-eye text-success"></i>
                        </button>
                    </div>
                </div>
                <div class="row">
                    <hr class="bg-white mt-5" style="border-radius: 30px; padding: 2px;" />
                    <div class=" table-responsive card card-body">
                        <table class="table table-sm" id="dt_basic2">
                            <thead>
                                <th>#</th>
                                <th><?php echo $this->lang->line('name'); ?></th>
                                <th><?php echo $this->lang->line('email'); ?></th>
                                <th><?php echo $this->lang->line('phone_number'); ?></th>
                                <th><?php echo $this->lang->line('address'); ?></th>
                                <th><?php echo $this->lang->line('credit'); ?></th>
                                <th><?php echo $this->lang->line('limit_credit'); ?></th>
                                <th><?php echo $this->lang->line('customer_card'); ?></th>
                                <th><?php echo $this->lang->line('active'); ?></th>
                                <th><?php echo $this->lang->line('date_created'); ?></th>
                            </thead>
                            <tbody>
                                <?php foreach ($customers as $c) : ?>
                                    <tr class="userRow" rel-customer="<?php print $c->customerId ?>">
                                        <td><a href="/admin/customers/customerForm/<?php print $c->customerId ?>" class="btn btn-link btn-xs" title="<?php echo $this->lang->line('customers'); ?>"><?php print $c->customerId ?></a></td>
                                        <td><?php print $c->customerName; ?></td>
                                        <td><?php print $c->email; ?></td>
                                        <td><?php print $c->phoneNumber; ?></td>
                                        <td><?php print $c->address; ?></td>
                                        <td><?php print number_format($c->credits, 2); ?></td>
                                        <td><?php print number_format($c->creditsLimit, 2); ?></td>
                                        <td><a href="<?php echo site_url(); ?>admin/customers/customerPrice/<?php print $c->customerId ?>" class="btn-link"><?php echo $this->lang->line('customer_card'); ?></a></td>
                                        <td>
                                            <?php if ($c->isActive) : ?>
                                                <span class="badge bg-success"><?php echo $this->lang->line('active'); ?></span>
                                            <?php else : ?>
                                                <span class="badge bg-danger"><?php echo $this->lang->line('not_active'); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo date('d/m/Y', strtotime($c->creationDate)); ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/bootbox.js/5.5.2/bootbox.min.js" integrity="sha512-RdSPYh1WA6BF0RhpisYJVYkOyTzK4HwofJ3Q7ivt/jkpW6Vc8AurL1R+4AUcvn9IwEKAPm/fk7qFZW3OuiUDeg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.0/js/bootstrap-datepicker.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.0/css/bootstrap-datepicker.css">
<style>
    .dataTables_filter {
        background-color: transpa;
        padding: 0px !important;
        margin: 20px 0;
        border: none;
        box-shadow: none;
    }

    /* #dt_basic2 {
    } */
</style>
<script>
    <?php
    $url = '';
    if ($this->session->userdata('site_lang') == 'hebrew') {
        $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Hebrew.json';
    } else if ($this->session->userdata('site_lang') == 'arabic') {
        $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Arabic.json';
    } else if ($this->session->userdata('site_lang') == 'english') {
        $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json';
    } else {
        $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Hebrew.json';
    }
    ?>
    $(document).ready(function() {
        var oTbl1 = $('#dt_basic2').DataTable({
            "sDom": "<'dt-toolbar'<'col-xs-12 col-sm-6'f><'dt-buttons col-sm-6 col-xs-12 hidden-xs'l>r>" +
                "t" +
                "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-xs-12 col-sm-6'p>>",
            "buttons": [],
            "processing": false,
            "bStateSave": false,
            "dom": 'Blfrtip',
            "order": [
                [0, "asc"]
            ],
            "pagingType": "full_numbers",
            "lengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "<?php echo $this->lang->line('Everything'); ?>"]
            ],
            "pageLength": 10,
            "sPaginationType": "full_numbers",
            "iDisplayLength": 20,
            "scrollX": true,
            "language": {
                "url": "<?php echo $url; ?>"
            },

            orderCellsTop: true,
            fixedHeader: true
        });

        $(document).on('click', '#dt_basic2 tbody tr', function() {
            let elem = $(this);
            let rowAttr = elem.attr('rel-customer');
            $('tr').css('background-color', "white");
            elem.css('background-color', "#e3edff")
            $('#deleteInvoiceButton').css('border-color', "#e9200c");
            $('#viewInvoiceButton').css('border-color', "#27b980");

            $('#deleteInvoiceButton').attr('rel-customer', rowAttr);
            $('#viewInvoiceButton').attr('rel-customer', rowAttr);
            $('#send_between').attr('rel-customer', rowAttr);
        });

        $('#viewInvoiceButton').on('click', function() {
            let elem = $('#viewInvoiceButton').attr('rel-customer');
            if (elem == undefined || elem == "") {
                bootbox.alert("Please, Choose a customer first");
            } else {
                window.location.href = `<?php echo site_url(); ?>/admin/customers/customerPrice/${elem}`;
            }
        });

        // $('#deleteInvoiceButton').on('click', function() {
        //     let elem = $('#viewInvoiceButton').attr('rel-customer');
        //     if (elem == undefined || elem == "") {
        //         bootbox.alert("Please, Choose a customer first");
        //     } else {
        //         $.post(root + 'admin/customers/disableCustomer', data, function(d) {

        //         });
        //     }
        // });
    });
</script>
<style>
    table#dt_basic2 {
        width: 100% !important;
    }
</style>