<script src="<?php echo site_url(); ?>assets/js/plugin/datatables1_10_7/jquery.dataTables.min.js"></script>
<script src="<?php echo site_url(); ?>assets/js/plugin/datatables/dataTables.colReorder.min.js"></script>
<script src="<?php echo site_url(); ?>assets/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="<?php echo site_url(); ?>assets/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="<?php echo site_url(); ?>assets/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="<?php echo site_url(); ?>assets/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>


<!-- MAIN PANEL -->
<div id="main" role="main">

    <!-- MAIN CONTENT -->
    <div id="content" style=" padding-top: 0px; ">

        <div class="row">

            <div class="col col-lg-12 table-responsive">
                <h1><?php echo $this->lang->line('cashboxes'); ?></h1>
                <hr />
                <br />
                <br />
            </div>
            <div class="col col-lg-6 table-responsive">
                <table class="table table-bordered" id="dt_basic2">
                    <thead>
                        <th>#</th>
                        <th><?php echo $this->lang->line('name'); ?></th>
                        <th><?php echo $this->lang->line('category'); ?></th>
                        <th><?php echo $this->lang->line('logo'); ?></th>
                        <th><?php echo $this->lang->line('type_of_transfer'); ?></th>
                        <th></th>
                    </thead>
                    <tbody>
                        <?php foreach ($payment_boxes as $box) { ?>
                            <tr rel="<?php echo $box->box_id; ?>">
                                <td><?php echo $box->box_id; ?></td>
                                <td>
                                    <input type="text" class="form-control box_name" value="<?php echo $box->name; ?>" />
                                </td>
                                <td>
                                    <select class="form-control box_category">
                                        <?php foreach ($boxes_category as $cat) { ?>
                                            <option <?php if ($cat->category == $box->category) {
                                                        echo 'selected="selected"';
                                                    }; ?> value="<?php echo $cat->category; ?>"><?php echo $cat->category; ?></option>
                                        <?php }; ?>
                                    </select>
                                </td>
                                <td><img src="<?php echo site_url() . 'assets/img/' . $box->logo; ?>" style="width:30px;" /></td>
                                <td>
                                    <select class="form-control convert_type" rel="<?php echo $box->box_id; ?>">
                                        <option <?php if ($box->convert_type == 1) {
                                                    echo "selected='selected'";
                                                }; ?> value="1"><?php echo $this->lang->line('button'); ?></option>
                                        <option <?php if ($box->convert_type == 2) {
                                                    echo "selected='selected'";
                                                }; ?> value="2"><?php echo $this->lang->line('general'); ?></option>
                                        <option <?php if ($box->convert_type == 3) {
                                                    echo "selected='selected'";
                                                }; ?> value="3"><?php echo $this->lang->line('general_button'); ?></option>
                                    </select>
                                </td>
                                <td>
                                    <a href="#0" class="btn btn-success btn-circle edit_current_box">
                                        <i class="fa fa-check"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php }; ?>
                    </tbody>
                </table>
            </div>
            <div class="col col-lg-6">
                <h2><?php echo $this->lang->line('add_cashbox'); ?></h2>
                <hr />
                <div class="well well-light">
                    <form id="addBox-form" class="smart-form" novalidate="novalidate" method="post" action="<?php print site_url(); ?>admin/invoices/addBox">
                        <fieldset>
                            <div class="row">
                                <section class="col col-md-4">
                                    <label class="label"><?php echo $this->lang->line('name'); ?></label>
                                    <label class="input">
                                        <i class="icon-append fa fa-asterisk"></i>
                                        <input type="text" name="name" value="" />
                                    </label>
                                </section>

                                <section class="col col-md-4">
                                    <label class="label"><?php echo $this->lang->line('type_of_transfer'); ?></label>
                                    <label class="input">
                                        <select class="select2" name="convert_type">
                                            <option value="1"><?php echo $this->lang->line('button'); ?></option>
                                            <option value="2"><?php echo $this->lang->line('general'); ?></option>
                                            <option value="3"><?php echo $this->lang->line('general_button'); ?></option>
                                        </select>
                                    </label>
                                </section>
                                <section class="col col-md-4">
                                    <label class="label"><?php echo $this->lang->line('category'); ?></label>
                                    <label class="input">
                                        <select class="select2" name="category">
                                            <?php foreach ($boxes_category as $cat) { ?>
                                                <option value="<?php echo $cat->category; ?>"><?php echo $cat->category; ?></option>
                                            <?php }; ?>
                                        </select>
                                    </label>
                                </section>

                                <section class="col col-md-6">
                                    <button type="submit" id="add_box_btn" class="btn btn-block btn-group btn-sm btn-success">
                                        <?php echo $this->lang->line('save'); ?>
                                    </button>
                                </section>
                            </div>
                        </fieldset>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- END MAIN CONTENT -->
</div>

<script type="text/javascript">
    <?php
    $url = '';
    if ($this->session->userdata('site_lang') == 'hebrew') {
        $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Hebrew.json';
    } else if ($this->session->userdata('site_lang') == 'arabic') {
        $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Arabic.json';
    } else if ($this->session->userdata('site_lang') == 'english') {
        $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json';
    } else {
        $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Hebrew.json';
    }
    ?>
    $(document).ready(function() {

        var oTbl1 = $('#dt_basic2').DataTable({
            "sDom": "<'dt-toolbar'<'col-xs-12 col-sm-6'f><'dt-buttons col-sm-6 col-xs-12 hidden-xs'l>r>" +
                "t" +
                "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-xs-12 col-sm-6'p>>",
            "buttons": ['copyHtml5', 'excelHtml5', 'csvHtml5', 'colvis'],
            "processing": true,
            //"serverSide": true,
            //"ajax": root + 'admin/ajax/getDataForTable',
            "bStateSave": true,
            "dom": 'Blfrtip',
            "pagingType": "full_numbers",
            "lengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "<?php echo $this->lang->line('Everything'); ?>"]
            ],
            "pageLength": 20,
            "sPaginationType": "full_numbers",
            "iDisplayLength": 10,
            "language": {
                "url": "<?php echo $url; ?>"
            },
            orderCellsTop: true,
            fixedHeader: true
        });

        $('input[aria-controls="dt_basic2"]').attr('placeholder', '<?php echo $this->lang->line('searh1'); ?>...');

        $('#dt_basic2_info').css('float', 'left').parent().css('float', 'left');
        $('.dataTables_paginate ').parent().css('float', 'right');
        $('.dataTables_paginate ').css('text-align', 'right');

        $(document).on('click', '.edit_current_box', function() {

            var data = {};
            data.box_id = $(this).parent().parent().attr("rel");
            data.box_name = $(this).parent().parent().find('.box_name').val();
            data.box_category = $(this).parent().parent().find('.box_category').val();

            $.post(root + 'admin/invoices/editBoxDetails', data, function(d) {

                if (d.result == true) {
                    $.smallBox({
                        title: "<?php echo $this->lang->line('Saved_successfully'); ?>",
                        content: "<?php echo $this->lang->line('Saved_successfully'); ?>",
                        color: "#739E73",
                        iconSmall: "fa fa-thumbs-up bounce animated",
                        timeout: 2500
                    });
                } else {
                    alert("<?php echo $this->lang->line('error_please_try_again'); ?>");
                    location.reload();
                }

            }, 'json');
        });

        $(document).on('change', '.convert_type', function() {
            var data = {};
            data.box_id = $(this).attr("rel");
            data.convertType = $(this).val();

            $.post(root + 'admin/ajax/changeBoxConvertType', data, function(d) {

                if (d.result == true) {
                    $.smallBox({
                        title: "<?php echo $this->lang->line('Saved_successfully'); ?>",
                        content: "<?php echo $this->lang->line('Saved_successfully'); ?>",
                        color: "#739E73",
                        iconSmall: "fa fa-thumbs-up bounce animated",
                        timeout: 2500
                    });
                } else {
                    alert("<?php echo $this->lang->line('error_please_try_again'); ?>");
                    location.reload();
                }

            }, 'json');
        });
    });
</script>