<?php
if (
    !isset($permissions['finance']['invoices'])
    || isset($permissions['finance']['invoices'])
    && $permissions['finance']['invoices'] == 0
) redirect('admin/dashboard');

?>
<script src="https://cdn.lordicon.com/libs/mssddfmo/lord-icon-2.1.0.js"></script>
<div id="main p-0" role="main">
    <!-- <div class="header-bg shadow-lg p-0" style="background: url(https://images.pexels.com/photos/1487834/pexels-photo-1487834.jpeg?auto=compress&cs=tinysrgb&dpr=2&h=750&w=1260)"></div> -->
    <div id="content" style=" padding-top: 0px; ">
        <div class="container">
            <div class="row mt-3 justify-content-center">
                <div class="header_invoice_wrapper shadow">
                    <div class="fs-1 w-25 text-white d-flex align-items-center"><?php echo $this->lang->line('payments'); ?></div>
                    <div class="new_invoice_btn">
                        <button type="button" class="shadow-lg add_invoice_button" data-bs-toggle="modal" data-bs-target="#myModal" title="<?php echo $this->lang->line('new_invoice'); ?>">
                            <lord-icon src="https://cdn.lordicon.com/mecwbjnp.json" trigger="loop" delay="1000" colors="primary:#356359,secondary:#00bcd4" style="width:32px;height:32px">
                            </lord-icon>
                            <span class="pt-1 text-dark">
                                <?php echo $this->lang->line('Production_receipt'); ?>
                            </span>
                        </button>
                        <!-- <button type="button" class="shadow-lg add_invoice_button" id="myModal" data-bs-toggle="modal" data-bs-target="#myModalModal" title="<?php echo $this->lang->line('Production_receipt'); ?>">
                                <lord-icon src="https://cdn.lordicon.com/mecwbjnp.json" trigger="loop" delay="1000" colors="primary:#356359,secondary:#00bcd4" style="width:32px;height:32px">
                                </lord-icon>
                                <span class="pt-1 text-dark">
                                    <?php echo $this->lang->line('Production_receipt'); ?>
                                </span>
                            </button> -->
                        <button type="button" class="shadow-lg excel_exporter cancel_invoice p-2" style="width: 50px;" data-bs-toggle="collapse" href="#date_search" role="button" aria-expanded="false" aria-controls="date_search">
                            <i class="fa fa-search "></i> </button>
                        <button type="button" class="shadow-lg excel_exporter cancel_invoice p-2" style="width: 50px;" data-bs-toggle="modal" id="send_between" rel-payment="-1">
                            <i class="fa fa-retweet text-primary"></i></button>
                        <button type="button" class="shadow-lg excel_exporter text-success" style="padding: 0 18px;" data-bs-toggle="modal" data-bs-target="#ExcelExportModal">
                            <i class="fas fa-file-excel text-success"></i>
                        </button>
                        <button type="button" class="shadow-lg excel_exporter cancel_invoice p-2" style="width: 50px;" data-bs-toggle="modal" id="" rel-payment="-1" data-bs-target="#">
                            <i class="fas fa-file-pdf text-warning"></i>
                        </button>
                        <button type="button" class="shadow-lg excel_exporter cancel_invoice p-2" style="width: 50px;" data-bs-toggle="modal" id="" rel-payment="-1" data-bs-target="#">
                            <i class="fas fa-copy text-primary"></i>
                        </button>
                        <button type="button" class="shadow-lg excel_exporter cancel_invoice p-2" style="width: 50px;" data-bs-toggle="modal" id="deleteInvoiceButton" rel-payment="-1" data-bs-target="#DeleteInvoice">
                            <i class="pt-1 me-1 fas fa-trash-alt text-danger"></i>
                        </button>
                        <button type="button" class="shadow-lg excel_exporter view_invoice p-2" style="width: 50px;" data-bs-toggle="modal" id="viewInvoiceButton" rel-payment="-1" data-bs-target="#DeleteInvoice">
                            <i class="pt-1 me-1 fas fa-eye text-success"></i>
                        </button>
                    </div>
                </div>
                <div class="w-100 collapse show position-relative" id="date_search">
                    <div class="date-searchWrapper" style="margin-left: 10px;">
                        <div class="p-3 w-50 bg-white mx-auto" style="border-radius: 0 0 20px 20px; float: left;">
                            <form class="w-75 mx-auto" method="POST">
                                <div class="form-group">
                                    <div class="d-flex justify-content-between">
                                        <div class="form-group">
                                            <div class="input">
                                                <input type="text" class="form-control text-center datepicker" name="firstPayDate" id="firstPayDate" type="text" placeholder="<?php echo $this->lang->line('from_date'); ?>" value="" autocomplete="off" style="width: 100%;">
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="input">
                                                <input class="form-control text-center datepicker" name="firstPayToDate" id="firstPayToDate" type="text" placeholder="<?php echo $this->lang->line('to_date'); ?>" value="" autocomplete="off" style="width: 100%;">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="button-group">
                                    <div class="form-group">
                                        <button class="btn btn-danger p-1" type="submit"><i class="fa fa-search"></i><?php echo $this->lang->line('search'); ?></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <hr class="bg-white mt-5" style="border-radius: 30px; padding: 2px;" />
                    <div class=" table-responsive card card-body">
                        <table class="table table-sm" id="supPaymentTable">
                            <thead>
                                <th>#</th>
                                <th><?php echo $this->lang->line('supplier'); ?></th>
                                <th><?php echo $this->lang->line('total'); ?></th>
                                <th><?php echo $this->lang->line('status'); ?></th>
                                <th><?php echo $this->lang->line('comment'); ?></th>
                                <th><?php echo $this->lang->line('date'); ?></th>
                            </thead>
                            <tbody>
                                <?php foreach ($payments as $payment) { ?>
                                    <tr rel-payment="<?php echo $payment->id; ?>">
                                        <td><?php echo $payment->id; ?></td>
                                        <td>
                                            <?php echo getSupplierName($payment->supplier_id); ?>
                                        </td>
                                        <td><span class=" totalOf_payment <?php echo $payment->cancel_id != 0 ? "badge rounded-pill bg-danger text-white" : "badge rounded-pill bg-primary text-white"; ?>"> <?php echo $payment->total; ?> </span>
                                        </td>
                                        <td><?php echo $payment->status; ?></td>
                                        <td><?php echo $payment->custComment; ?></td>
                                        <td><?php echo date("d/m/Y", strtotime($payment->payment_date)); ?></td>
                                    </tr>
                                <?php }; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal" id="createPaymentModal" tabindex="-1" role="dialog" aria-labelledby="createPaymentModal" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-xl" role="document" title="<?php echo $this->lang->line('Production_receipt'); ?>">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="createPaymentModalTitle">
                    <?php echo $this->lang->line('Production_receipt'); ?>
                </h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form action="no-action" method="POST" class="smart-form" id="payment_dataz">
                    <div class="row">

                        <div class="col col-lg-12">
                            <label for="payment_box"><?php echo $this->lang->line('send_to'); ?>: </label>
                            <select style="width: 460px;" name="supplier_id" class="select2" id="supplier_id">
                                <optgroup style="width: 400px;" class="companies_list_from" label="<?php echo $this->lang->line('customers'); ?>">
                                    <option value=""><?php echo $this->lang->line('select2'); ?></option>
                                    <?php foreach ($suppliers as $supplier) { ?>
                                        <option value="<?php echo $supplier->supplier_id; ?>"><?php echo $supplier->name; ?></option>
                                    <?php }; ?>
                                </optgroup>
                            </select>

                        </div>

                        <div class="col col-lg-12">
                            <hr /><br />
                        </div>

                        <div class="col col-lg-6 col-sm-12 col-md-12">
                            <label for="payment_box"><?php echo $this->lang->line('cashbox'); ?></label>
                            <label class="select">
                                <select name="payment_box" class="form-control">
                                    <?php foreach ($payment_boxes as $payment_box) { ?>
                                        <option value="<?php echo $payment_box->box_id; ?>"><?php echo $payment_box->name; ?></option>
                                    <?php }; ?>
                                </select>
                                <i></i>
                            </label>
                        </div>

                        <div class="col col-lg-6 col-sm-12 col-md-12">
                            <label for="payment_type"><?php echo $this->lang->line('payment_method'); ?></label>
                            <label class="select">
                                <select name="payment_type" class="form-control">
                                    <?php foreach ($payment_types as $payment_type) { ?>
                                        <option value="<?php echo $payment_type->type_id; ?>"><?php echo $payment_type->name; ?></option>
                                    <?php }; ?>
                                </select>
                                <i></i>
                            </label>
                            <br />
                        </div>

                        <div class="col col-lg-6 col-sm-12 col-md-12">
                            <label for="payment_date"><?php echo $this->lang->line('date'); ?></label>
                            <label class="input">
                                <input type="text" value="<?php echo date('Y-m-d H:i:s'); ?>" name="payment_date" class="form-control datepicker payment_date" />
                            </label>
                        </div>

                        <div class="col col-lg-6 col-sm-12 col-md-12">
                            <label for="bank_visa"><?php echo $this->lang->line('bank_visa'); ?></label>
                            <label class="input">
                                <input type="text" value="" name="bank_visa" class="form-control" />
                            </label>
                            <br />
                        </div>

                        <div class="col col-lg-6 col-sm-12 col-md-12">
                            <label for="branch_digits"><?php echo $this->lang->line('Branch_digits'); ?></label>
                            <label class="input">
                                <input type="text" value="" name="branch_digits" class="form-control" />
                            </label>
                        </div>

                        <div class="col col-lg-6 col-sm-12 col-md-12">
                            <label for="account_card"><?php echo $this->lang->line('invoice_validity'); ?></label>
                            <label class="input">
                                <input type="text" value="" name="account_card" class="form-control" />
                            </label>
                            <br />
                        </div>

                        <div class="col col-lg-6 col-sm-12 col-md-12">
                            <label for="reference_id"><?php echo $this->lang->line('reference_id_num'); ?></label>
                            <label class="input">
                                <input type="text" value="" name="reference_id" class="form-control" />
                            </label>
                        </div>

                        <div class="col col-lg-6 col-sm-12 col-md-12">
                            <label for="total_payment"><?php echo $this->lang->line('sum'); ?></label>
                            <label class="input">
                                <input type="text" value="" name="total_payment" class="form-control" />
                            </label>
                            <br />
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo $this->lang->line('close'); ?></button>
                <button type="button" class="btn btn-primary" id="savePaymentDetails" style="float:left;"><?php echo $this->lang->line('save'); ?></button>
            </div>
        </div>
    </div>
</div>
<div class="modal" id="convert_box" tabindex="-1" role="dialog" aria-labelledby="convert_boxModal" aria-hidden="true" title="<?php echo $this->lang->line('transference_sunds'); ?>">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="createPaymentModalTitle">
                    <?php echo $this->lang->line('transference_sunds'); ?>
                </h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form action="no-action" method="POST" class="smart-form" id="convert_boxForm">
                    <input type="hidden" value="" id="payment_id" />
                    <div class="row">

                        <div class="col col-lg-6 col-sm-12 col-md-12">
                            <label for="payment_box"><?php echo $this->lang->line('transfer_to'); ?></label>
                            <label class="select">
                                <select name="payment_box" id="new_payment_box" class="form-control">
                                    <?php foreach ($payment_boxes as $payment_box) { ?>
                                        <option value="<?php echo $payment_box->box_id; ?>"><?php echo $payment_box->name; ?></option>
                                    <?php }; ?>
                                </select>
                                <i></i>
                            </label>
                        </div>

                        <div class="col col-lg-6 col-sm-12 col-md-12">
                            <label for="payment_type"><?php echo $this->lang->line('payment_method'); ?></label>
                            <label class="select">
                                <select name="payment_type" id="new_payment_type" class="form-control">
                                    <?php foreach ($payment_types as $payment_type) { ?>
                                        <option value="<?php echo $payment_type->type_id; ?>"><?php echo $payment_type->name; ?></option>
                                    <?php }; ?>
                                </select>
                                <i></i>
                            </label>
                            <br />
                        </div>

                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo $this->lang->line('close'); ?></button>
                <button type="button" class="btn btn-primary" id="convert_box_data" style="float:left;"><?php echo $this->lang->line('save'); ?></button>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="ExcelExportModal" tabindex="-1" aria-labelledby="ExcelExportModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content position-relative p-3" style="background-color: #f5f5f5;">
            <!-- <form action="no-action" method="POST" id="search_form"> -->
            <div class="modal-body" style="background-color: #f5f5f5;">
                <div class="close_modal" id="close_ExportModal" rel-export="true">
                    <i class="fas fa-times-circle text-danger"></i>
                </div>
                <div class="d-flex flex-column justify-content-center align-items-center w-75 excel-container">
                    <div class="excelTitle">
                        <?php echo $this->lang->line('Filter_export_by'); ?>
                    </div>
                    <div class="ExcelFilteration">
                        <div class="label-excel-wrapper">
                            <input type="checkbox" name="exportByCustome" id="exportByCustomer" rel-exportby="customer">
                            <label for="exportByCustomer"><?php echo $this->lang->line('By_Customer'); ?>:</label>
                        </div>
                        <div class="exportChoice_wrapper">
                            <select name="" id="selectCustomer" class="w-100"></select>
                        </div>
                    </div>
                    <hr class="w-100 mx-auto bg-success">
                    <div class="ExcelFilteration">
                        <div class="label-excel-wrapper">
                            <input type="checkbox" name="exportByInvoice" id="exportByInvoice" rel-exportby="invoice">
                            <label for="exportByInvoice"><?php echo $this->lang->line('By_Invoice'); ?>:</label>
                        </div>
                        <div class="exportChoice_wrapper">
                            <select name="" id="selectInvoiceFrom" class="w-100 mb-2"></select>
                            <select name="" id="selectInvoiceTo" class="w-100"></select>
                        </div>
                    </div>
                    <hr class="w-100 mx-auto bg-success">
                    <div class="ExcelFilteration">
                        <div class="label-excel-wrapper">
                            <input type="checkbox" name="exportByDate" id="exportByDate" rel-exportby="date">
                            <label for="exportByDate"><?php echo $this->lang->line('By_Date'); ?>:</label>
                        </div>
                        <div class="exportChoice_wrapper">
                            <input type="text" placeholder="From Date" name="invoice_date" id="invoiceDateFrom" class="datepicker form-control" />
                            <input type="text" placeholder="To Date" name="invoice_date" id="invoiceDateTo" class="datepicker form-control" />
                        </div>
                    </div>
                    <div class="excel_execute w-100 mt-3">
                        <button class="btn btn-primary btn-sm p-1 float-start" id="buildExcel">
                            Export
                        </button>
                    </div>
                </div>
            </div>
            <!-- </form> -->
        </div>
    </div>
</div>
<div class="modal" id="myModal" role="dialog">
    <div class="modal-dialog modal-dialog-centered ">
        <div class="modal-content position-relative">
            <div class="close_modal" id="close_modal">
                <i class="fas fa-times-circle text-danger"></i>
            </div>
            <div class="modal-body" style="background-color: #f5f5f5;">
                <div id="content">
                    <form action="no-action" method="POST" class="smart-form" id="payment_data">
                        <div class="first-stage position-relative" id="page_one">
                            <div class="form-header">
                                <div class="invoice-head">
                                    <label for=""><?php echo $this->lang->line('Production_receipt'); ?></label>
                                    <input class="form-control" value="<?php echo $lastSupplierPaymentId ?>" name="payment_code"  readonly />
                                </div>
                                <div class="invoice-head">
                                    <label for=""><?php echo $this->lang->line('date'); ?></label>
                                    <input type="text" value="<?php $now = date('Y-m-d');
                                                                echo date("d/m/Y", strtotime($now)); ?>" name="payment_date" id="payment_date" class=" datepicker form-control p-0 py-2" />
                                </div>
                            </div>
                            <div class="">
                                <div class="form-full">
                                    <label for=""><?php echo $this->lang->line('supplier'); ?></label>
                                    <div class="selectorHolder">
                                        <select class="select2" id="payment_for" name="payment_for">
                                            <optgroup class="companies_list_from" label="ספקים" id="paymnet_for" name="payment_for">
                                                <option value="">נא בחר</option>
                                                <?php foreach ($suppliers as  $supplier) { ?>
                                                    <option value="<?php echo $supplier->supplier_id; ?>"><?php echo $supplier->name; ?></option>
                                                <?php  } ?>
                                            </optgroup>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-full">
                                    <div class="invoice-custom_75 d-flex" style="width: 80%;">
                                        <label for="" class="" style="width: 20.3%;">
                                            <div style="max-width: 20px;">
                                                <?php echo $this->lang->line('manger_note'); ?>
                                            </div>
                                        </label>
                                        <input id="fill_boss_Comment1" class="form-control w-75" name="boss_Comment">
                                    </div>
                                    <div class="invoice-custom_25 d-flex" style="width: 30%">
                                        <label class="w-50"><?php echo $this->lang->line('customer_balance'); ?></label>
                                        <input id="customer_credit" type="text" class="form-control w-50 p-1 text-center" value="" readonly name="customer_credit" style="font-size:8px; color: tomato !important; font-weight: bold !important;" />
                                    </div>
                                </div>
                                <div class="form-full">
                                    <label for=""><?php echo $this->lang->line('details'); ?></label>
                                    <input class="form-control fill_cust_comment" name="custComment" id="custComment">
                                </div>
                                <div class="form-full" style="margin-top: 50px;">
                                    <label for=""><?php echo $this->lang->line('notes'); ?></label>
                                    <textarea class="form-control" style="width: 85%; height: 150px;" placeholder="<?php echo $this->lang->line('Enter_your_comment'); ?>" id="comment1" name="comment1"></textarea>
                                </div>
                            </div>
                            <div class="row w-100 d-flex justify-content-end m-0">
                                <button type="button" class="btn btn-success rounded float-left p-1 next-stage" style="width: 100px;">
                                    <?php echo $this->lang->line('confirm'); ?>
                                </button>
                            </div>
                        </div>
                        <page size="A4" style="display: none;">
                            <div class="second_stage_header row align-items-start">
                                <div class="right-section w-50">
                                    <div class="w-50 m-2">
                                        <label for="" class="me-1"><?php echo $this->lang->line('Production_receipt'); ?>: </label>
                                        <label for="" class="fw-bold"><? //php echo getNewPaymentNo()  
                                                                        ?></label>
                                    </div>
                                    <div class="w-50 m-2">
                                        <label for="" class="me-1" name="customer" id="customer"><?php echo $this->lang->line('customer'); ?>: </label>
                                        <label for=""></label>
                                    </div>
                                    <div class="form-full w-50 m-2">
                                        <label for="" class="me-1"><?php echo $this->lang->line('details'); ?>: </label>
                                        <input class="form-control" name="cust_comment" id="cust_comment" readonly>
                                    </div>
                                </div>
                                <div class="left-section w-50">
                                    <div class="invoice-head w-50 m-2">
                                        <label for="" class="me-1"><?php echo $this->lang->line('date'); ?>: </label>
                                        <input class="form-control" value="" name="payment_date1" id="payment_date1">
                                    </div>
                                </div>
                            </div>
                            <div class="row container-sm mx-auto p-0">
                                <div class="col col-lg-12 col-md-12 col-sm-12" id="payment_details">
                                    <table class="table" id="payment_table">
                                        <thead>
                                            <tr class="items">
                                                <th style="width: 5px;"><?php echo $this->lang->line('actions'); ?></th>
                                                <th><?php echo $this->lang->line('payment_method'); ?></th>
                                                <th><?php echo $this->lang->line('cashbox'); ?></th>
                                                <th><?php echo $this->lang->line('sum'); ?></th>
                                                <th class="check_items shared_items"><?php echo $this->lang->line('bank_visa'); ?></th>
                                                <th class="check_items shared_items"><?php echo $this->lang->line('Branch_digits'); ?></th>
                                                <th class="check_items shared_items"><?php echo $this->lang->line('invoice_validity'); ?></th>
                                                <th class="bank_items"><?php echo $this->lang->line('reference_id_num'); ?></th>
                                                <th class="check_items">check number</th>
                                                <th class="check_items shared_items"><?php echo $this->lang->line('date'); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr class="items">
                                                <td style="width: 5px;">
                                                    <div href="#0" class="remove_this_item btn btn-sm bg-danger text-white p-1">
                                                        <i class="fa fa-times"></i>
                                                    </div>
                                                </td>
                                                <td style="  text-align: center;">
                                                    <select style="width:100px;" name="items[payment_method][]" class="payment_method">
                                                        <option value="0"><?php echo $this->lang->line('select'); ?></option>
                                                        <?php foreach ($payment_types as $payment_type) { ?>
                                                            <option value="<?php echo $payment_type->type_id; ?>"><?php echo $payment_type->name; ?></option>
                                                        <?php }; ?>
                                                    </select>
                                                    <!-- <input type="hidden" name="items[code][]"> -->
                                                </td>
                                                <td style="  text-align: center;">
                                                    <select style="width:100px;" name="items[cashbox][]" class="cash_box">
                                                        <option value="0">נא בחר</option>
                                                        <?php foreach ($payment_boxes as $payment_box) { ?>
                                                            <option value="<?php echo $payment_box->box_id; ?>"><?php echo $payment_box->name; ?></option>
                                                        <?php }; ?>
                                                    </select>
                                                    <!-- <input type="hidden" name="items[code][]"> -->
                                                </td>
                                                <td>
                                                    <input type="text" value="" name="items[sum][]" class="payment_sum form-control text-center" />
                                                </td>
                                                <td class="check_items shared_items">
                                                    <input type="text" value="" name="items[bank_visa][]" class="bank_visa form-control text-center" />
                                                    <input type="hidden" value="" name="items[hidden_bank][]" class="hidden_bank form-control text-center" />
                                                </td>
                                                <td class="check_items shared_items">
                                                    <input type="text" value="" name="items[Branch_digits][]" class="Branch_digits form-control text-center" style="width: 100%" />
                                                    <input type="hidden" value="" name="items[hidden_branch][]" class="hidden_branch form-control text-center" />
                                                </td>
                                                <td class="check_items shared_items">
                                                    <input type="text" value="" name="items[invoice_validity][]" class="invoice_validity form-control text-center" style="width: 100%;" />
                                                </td>
                                                <td class="bank_items">
                                                    <input type="text" value="" name="items[reference_id_num][]" class="reference_id_num form-control text-center" style="width: 100%;" />
                                                </td>
                                                <td class="check_items">
                                                    <input type="text" value="" name="items[check_number][]" class="check_number form-control text-center" style="width: 100%;" />
                                                </td>
                                                <td class="check_items shared_items">
                                                    <input type="text" value="" name="items[check_date][]" class=" datepicker check_date form-control text-center " style="width: 100%;" />
                                                </td>
                                            </tr>
                                            <tr id="btns_group">
                                                <td colspan="7" style="text-align:center;">
                                                    <a href="#0" class="btn btn-success btn-circle p-1" id="add_item">
                                                        <i class="fa fa-plus"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>

                                <div class="final_info">
                                    <div class="form-full">
                                        <textarea class="form-control w-75" style="height: 100px" placeholder="הערות" id="floatingTextarea" name="comment2"></textarea>
                                    </div>
                                    <div class="final_number">
                                        <div class="form-full mt-1" style="margin: 0px;">
                                            <label class="w-50 fw-bold" for="" style="font-size: 11px; font-weight: bold !important;"><?php echo $this->lang->line('total_before_vat'); ?></label>
                                            <input type="text" value="0" name="total_before_vat" class="fill_total_before_vat form-control w-50 text-center p-0" readonly />
                                        </div>
                                        <div class="form-full mt-1" style="margin: 0px;">
                                            <label class="w-50 fw-bold" for="" style="font-size: 11px; font-weight: bold !important;"><?php echo $this->lang->line('vat_17'); ?></label>
                                            <input type="text" value="0" name="vat" class="form-control w-50 fill_vat text-center p-0" readonly />
                                        </div>
                                        <div class="form-full mt-1" style="margin: 0px;">
                                            <label class="w-50 fw-bold" for="" style="font-size: 11px; font-weight: bold !important;"><?php echo $this->lang->line('total_shekel'); ?></label>
                                            <input type="text" value="0" name="total" class="fill_total form-control w-50 text-center p-0" readonly />
                                        </div>
                                    </div>
                                </div>

                                <div class="col col-lg-12 col-lg-12 col-sm-12">
                                    <div class="row justify-content-between">
                                        <div class="col-lg-3 d-flex align-items-center">
                                            <div class="invoice-custom_25 d-flex">
                                                <label class="w-50"><?php echo $this->lang->line('customer_balance'); ?></label>
                                                <input type="text" class="form-control w-50 p-1 text-center" value="" readonly name="credit1" id="credit1">
                                            </div>
                                        </div>
                                        <div class="align-items-center col-lg-5 d-flex justify-content-end">
                                            <button type="button" class="reverse-stage btn btn-primary p-1"><i class="fas fa-angle-right me-1"></i><?php echo $this->lang->line('back'); ?></button>
                                            <a href="#0" class="btn btn-danger" id="close_invoiceForm" style=" margin: 0 10px !important;padding: 4px 20px !important;">
                                                <?php echo $this->lang->line('close'); ?>
                                            </a>
                                            <button type="button" class="btn btn-success" id="savePaymentDetails" style="float:left; margin: 0 10px !important;padding: 4px 20px !important;"><?php echo $this->lang->line('save'); ?></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </page>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal" id="DeleteInvoice" role="dialog" style="display: none;">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content position-relative">
            <div class="close_modal" id="close_DeleteModal" rel-delete="true">
                <i class="fas fa-times-circle text-danger"></i>
            </div>
            <div class="modal-body" style="background-color: #f5f5f5;">
                <div id="content">
                    <form action="<?php echo site_url(); ?>admin/invoices/deleteSupplierInvoiceOnly" method="POST" id="deleteInvoiceForm" autocomplete="OFF">
                        <div class="first-stage">
                            <div class="form-header">
                                <div class="invoice-head">
                                    <label for=""><?php echo $this->lang->line('invoices'); ?></label>
                                    <input id="fill_invoice_code" class="form-control" value="" name="payment_code" readonly>
                                </div>
                                <div class="invoice-head">
                                    <label for=""><?php echo $this->lang->line('date'); ?></label>
                                    <input id="fill_invoice_date" type="text" name="invoice_date" class="datepicker form-control" readonly />
                                </div>
                            </div>
                            <div class="form-full">
                                <label for=""><?php echo $this->lang->line('supplier'); ?></label>
                                <div class="selectorHolder">
                                    <input type="text" class="form-control w-100" id="fill_customer" readonly>
                                </div>

                            </div>
                            <div class="form-full">
                                <div class="w-75 invoice-custom_75 d-flex">
                                    <label for="" class="" style="width: 20%;"><?php echo $this->lang->line('manger_note'); ?></label>
                                    <input id="fill_boss_Comment" class="form-control w-75" value="<?php echo $this->lang->line('Please_do_not_open_an_order_higher_than_1000'); ?>" name="boss_Comment" readonly>
                                </div>
                                <div class="w-25 invoice-custom_25 d-flex">
                                    <label class="w-50"><?php echo $this->lang->line('supplier_balance'); ?></label>
                                    <input id="fill_customer_credit" type="text" class="form-control w-50 p-1 text-center" value="" name="customer_credit" readonly style="font-size:8px; color: tomato !important; font-weight: bold !important;" />
                                </div>
                            </div>
                            <div class="form-full">
                                <label for=""><?php echo $this->lang->line('details'); ?></label>
                                <input class="form-control fill_cust_comment" name="custComment" id="custComment" readonly>
                            </div>
                            <div class="form-full" style="margin-top: 50px;">
                                <label for=""><?php echo $this->lang->line('notes'); ?></label>
                                <textarea id="fill_comment1" class="form-control" style="width: 85%; height: 150px;" placeholder="<?php echo $this->lang->line('Enter_your_comment'); ?>" name="comment1" readonly></textarea>
                            </div>
                            <div class="row w-100 d-flex justify-content-end m-0">
                                <button type="button" class="btn btn-primary rounded float-left p-1 next-stage" style="width: 100px;" rel-delete="true">
                                    <?php echo $this->lang->line('confirm'); ?>
                                </button>
                            </div>
                        </div>
                        <page size="A4" style="display: none;">
                            <div class="second_stage_header row align-items-start">
                                <div class="right-section w-50">
                                    <div class="w-50 m-2">
                                        <label for="" class="me-1"><?php echo $this->lang->line('Production_receipt'); ?>: </label>
                                        <label for="" class="fw-bold"><? //php echo getNewPaymentNo()  
                                                                        ?></label>
                                    </div>
                                    <div class="w-50 m-2">
                                        <label for="" class="me-1" name="customer" id="customer"><?php echo $this->lang->line('customer'); ?>: </label>
                                        <label for=""></label>
                                    </div>
                                    <div class="form-full w-50 m-2">
                                        <label for="" class="me-1"><?php echo $this->lang->line('details'); ?>: </label>
                                        <input class="form-control" name="cust_comment" id="cust_comment">
                                    </div>
                                </div>
                                <div class="left-section w-50">
                                    <div class="invoice-head w-50 m-2">
                                        <label for="" class="me-1"><?php echo $this->lang->line('date'); ?>: </label>
                                        <input class="form-control" value="" name="payment_date1" id="payment_date1">
                                    </div>
                                </div>
                            </div>
                            <div class="row container-sm mx-auto p-0">
                                <div class="col col-lg-12 col-md-12 col-sm-12" id="payment_details">
                                    <table class="table" id="payment_table">
                                        <thead>
                                            <tr class="items">
                                                <th><?php echo $this->lang->line('payment_method'); ?></th>
                                                <th><?php echo $this->lang->line('cashbox'); ?></th>
                                                <th><?php echo $this->lang->line('sum'); ?></th>
                                                <th class=""><?php echo $this->lang->line('bank_visa'); ?></th>
                                                <th class=""><?php echo $this->lang->line('Branch_digits'); ?></th>
                                                <th class=""><?php echo $this->lang->line('invoice_validity'); ?></th>
                                                <th class=""><?php echo $this->lang->line('reference_id_num'); ?></th>
                                                <th class=""><?php echo $this->lang->line('bank_check_number'); ?></th>
                                                <th class=""><?php echo $this->lang->line('date'); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>
                                </div>

                                <div class="final_info">
                                    <div class="form-full">
                                        <textarea class="form-control w-75" style="height: 100px" placeholder="<?php echo $this->lang->line('notes'); ?>" id="floatingTextarea" name="comment2"></textarea>
                                    </div>
                                    <div class="final_number">
                                        <div class="form-full mt-1" style="margin: 0px;">
                                            <label class="w-50 fw-bold" for="" style="font-size: 11px; font-weight: bold !important;"><?php echo $this->lang->line('total_before_vat'); ?></label>
                                            <input type="text" value="0" name="total_before_vat" class="fill_total_before_vat form-control w-50 text-center p-0" readonly />
                                        </div>
                                        <div class="form-full mt-1" style="margin: 0px;">
                                            <label class="w-50 fw-bold" for="" style="font-size: 11px; font-weight: bold !important;"><?php echo $this->lang->line('vat_17'); ?></label>
                                            <input type="text" value="0" name="vat" class="form-control w-50 fill_vat text-center p-0" readonly />
                                        </div>
                                        <div class="form-full mt-1" style="margin: 0px;">
                                            <label class="w-50 fw-bold" for="" style="font-size: 11px; font-weight: bold !important;"><?php echo $this->lang->line('total_shekel'); ?></label>
                                            <input type="text" value="0" name="total" class="fill_total form-control w-50 text-center p-0" readonly />
                                        </div>
                                    </div>
                                </div>

                                <div class="col col-lg-12 col-lg-12 col-sm-12">
                                    <div class="row justify-content-between">
                                        <div class="col-lg-3 d-flex align-items-center">
                                            <div class="invoice-custom_25 d-flex">
                                                <label class="w-50">יתרת הלקוח</label>
                                                <input type="text" class="form-control w-50 p-1 text-center" value="" name="credit1" id="credit1">
                                            </div>
                                        </div>
                                        <div class="align-items-center col-lg-5 d-flex justify-content-end">
                                            <button type="button" class="reverse-stage btn btn-primary p-1"><i class="fas fa-angle-right me-1"></i><?php echo $this->lang->line('back'); ?></button>
                                            <a href="#0" class="btn btn-danger" id="close_invoiceForm" rel-delete="true" style=" margin: 0 10px !important;padding: 4px 20px !important;">
                                                <?php echo $this->lang->line('close'); ?>
                                            </a>
                                            <button type="button" class="btn btn-success" id="updatePayment" rel-modaltype="delete" style="float:left; margin: 0 10px !important;padding: 4px 20px !important;"><?php echo $this->lang->line('save'); ?></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </page>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    <?php
    $url = '';
    if ($this->session->userdata('site_lang') == 'hebrew') {
        $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Hebrew.json';
    } else if ($this->session->userdata('site_lang') == 'arabic') {
        $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Arabic.json';
    } else if ($this->session->userdata('site_lang') == 'english') {
        $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json';
    } else {
        $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Hebrew.json';
    }
    ?>
    $(document).ready(function() {
        $('#supPaymentTable').DataTable({
            "sDom": "<'dt-toolbar'<'col-xs-12 col-sm-6'f><'dt-buttons col-sm-6 col-xs-12 hidden-xs'l>r>" +
                "t" +
                "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-xs-12 col-sm-6'p>>",
            "buttons": [],
            "processing": false,
            "bStateSave": false,
            "dom": 'Blfrtip',
            "pagingType": "full_numbers",
            "lengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "<?php echo $this->lang->line('Everything'); ?>"]
            ],
            "pageLength": 20,
            "sPaginationType": "full_numbers",
            "iDisplayLength": 10,
            "sScrollY": 500,
            "bScrollCollapse": true,
            "scrollX": true,
            "language": {
                "url": "<?php echo $url; ?>"
            },

            orderCellsTop: true,
            fixedHeader: false,
            searching: false
        });
        $('#send_between').on('click', function() {
            let elem = $(this);
            if (elem.attr("rel-payment") === "-1") {
                bootbox.alert("Please Select an invoice from the table below to continue");
                // $('#convert_box').modal('hide');
            } else {
                var payment_id = elem.attr('rel-payment');
                $('#payment_id').val(payment_id);
                $('#convert_box').modal('show');
            }
        });

        $('#convert_box_data').on('click', function() {

            var data = {};

            data.payment_id = $('#payment_id').val();
            // console.log(data.payment_id);
            data.new_box = $('#new_payment_box').val();
            data.new_payment = $('#new_payment_type').val();

            $.post(root + 'admin/invoices/convertPayment', data, function(d) {

                if (d.result == true) {
                    alert("<?php echo $this->lang->line('Done'); ?>!");
                    location.reload();
                } else {
                    alert("<?php echo $this->lang->line('Error'); ?>!");
                }

            }, 'json');
        });
        $(document).on('click', '#supPaymentTable tbody tr', function() {
            let elem = $(this);
            let rowAttr = elem.attr('rel-payment');
            $('tr').css('background-color', "white");
            elem.css('background-color', "#e3edff")
            $('#deleteInvoiceButton').css('border-color', "#e9200c");
            $('#viewInvoiceButton').css('border-color', "#27b980");

            $('#deleteInvoiceButton').attr('rel-payment', rowAttr);
            $('#viewInvoiceButton').attr('rel-payment', rowAttr);
            $('#send_between').attr('rel-payment', rowAttr);

        });
        $(document).on('click', '#savePaymentDetails', function() {
            var data = $('#payment_data').serializeArray();
            console.log('clicked');
            $.post(root + 'admin/invoices/addSupplierPayment', data, function(d) {
                if (d.result == true) {
                    alert("<?php echo $this->lang->line('Done'); ?>!");
                    location.reload();
                } else {
                    alert("<?php echo $this->lang->line('Error'); ?>!");
                }

            }, 'json');
        });

    });
    $(document).on('change', '.bank_visa', function(event) {
        let data = {};
        let elem = $(this);
        var row = elem.parent().parent();
        let id = elem.val();
        data.id = id;
        row.find(".hidden_bank").val(id);
        row.find(".Branch_digits").val("");

        $.post(root + 'admin/invoices/getbankDetails', data, function(d) {
            if (d.result == true) {
                elem.val(d.name);
                // console.log(row.find(".hidden_bank").val());
            } else {
                elem.val("");
            }

        }, 'json');


    });
    $(document).on('click', '.view_invoice', function() {
        let elem = $(this);
        let data = {};
        $('#updatePayment').hide();
        if (elem.attr("rel-payment") === "-1") {
            bootbox.alert("Please Select an invoice from the table below to continue");
            $('#DeleteInvoice').modal('hide');
        } else {
            data = {
                id: elem.attr("rel-payment"),
            }

            $.post(root + 'admin/invoices/getSupplierPaymentData', data, function(d) {
                if (d.result == true) {
                    let data = d.data.payment_info;
                    $('#fill_invoice_code').val(`${data.id}`);
                    $('#fill_customer_credit').val(`${data.supplierCredit}`);
                    $('.invoiceCodeLabel').text(`${data.id}`);
                    $('#fill_invoice_date').val(`${data.payment_date}`);
                    $('#fill_boss_Comment').val(`${data.bossComment}`);
                    $('#fill_customer').val(`${data.customerName}`);
                    $('#fill_customer2').text(`${data.customerName}`);
                    $('.fill_cust_comment').val(`${data.custComment}`);
                    $('#fill_comment1').val(`${data.comment1}`);
                    $('#fill_comment2').val(`${data.comment2}`);
                    $('#fill_invoice_date1').val(`${data.dateCreation}`);
                    $('.executeInvoiceDelete').attr('rel-payment', data.id);

                    let productsRows = ``;
                    let items = d.data.items;

                    for (let i = 0; i < items.length; i++) {
                        productsRows += `
                                    <tr class="items">
                                        <td>
                                            <input readonly type="text" value="${items[i].payment_method}" name="items[payment_method][]" class="payment_method form-control text-center" />
                                        </td>
                                        <td>
                                            <input readonly type="text" value="${items[i].box}" name="items[cashbox][]" class="cash_box form-control text-center" />
                                        </td>
                                        <td>
                                            <input readonly type="text" value="${items[i].payment_total}" name="items[sum][]" class="payment_sum form-control text-center" />
                                        </td>
                                        <td class="">
                                            <input readonly type="text" value="${items[i].bank_visa}" name="items[bank_visa][]" class="bank_visa form-control text-center" />
                                            <input readonly type="hidden" value="${items[i].bank_visa}" name="items[hidden_bank][]" class="hidden_bank form-control text-center"/>
                                        </td>
                                        <td class="">
                                            <input readonly type="text" value="${items[i].Branch_digits}" name="items[Branch_digits][]" class="Branch_digits form-control text-center" style="width: 100%;" />
                                            <input readonly type="hidden" value="${items[i].Branch_digits}" name="items[hidden_branch][]" class="hidden_branch form-control text-center"/>
                                        </td>
                                        <td class="">
                                            <input readonly type="text" value="" name="items[invoice_validity][]" class="invoice_validity form-control text-center" style="width: 100%;" />
                                        </td>
                                        <td class="">
                                            <input readonly type="text" value="${items[i].reference_number}" name="items[reference_id_num][]" class="reference_id_num form-control text-center" style="width: 100%;" />
                                        </td>
                                        <td class="">
                                            <input readonly type="text" value="${items[i].check_number}" name="items[check_number][]" class="check_number form-control text-center" style="width: 100%;" />
                                        </td>
                                        <td class="">   
                                            <input readonly type="text" value="${items[i].check_date}" name="items[check_date][]" class="datepicker check_date  form-control text-center "  style="width: 100%;" />
                                        </td>
                                    </tr>`;
                    }
                    $('#payment_table tbody').html(productsRows);
                    calcTotal();
                }
            }, 'json');
        }
    });
    $(document).on('dblclick', '#supPaymentTable tr', function() {
        let elem = $(this);
        let data = {};
        $('#updatePayment').hide();
        if (elem.attr("rel-payment") === "-1") {
            bootbox.alert("Please Select an invoice from the table below to continue");
            $('#DeleteInvoice').modal('hide');
        } else {
            data = {
                id: elem.attr("rel-payment"),
            }

            $.post(root + 'admin/invoices/getSupplierPaymentData', data, function(d) {
                if (d.result == true) {
                    let data = d.data.payment_info;
                    $('#fill_invoice_code').val(`${data.id}`);
                    $('#fill_customer_credit').val(`${data.supplierCredit}`);
                    $('.invoiceCodeLabel').text(`${data.id}`);
                    $('#fill_invoice_date').val(`${data.payment_date}`);
                    $('#fill_boss_Comment').val(`${data.bossComment}`);
                    $('#fill_customer').val(`${data.customerName}`);
                    $('#fill_customer2').text(`${data.customerName}`);
                    $('.fill_cust_comment').val(`${data.custComment}`);
                    $('#fill_comment1').val(`${data.comment1}`);
                    $('#fill_comment2').val(`${data.comment2}`);
                    $('#fill_invoice_date1').val(`${data.dateCreation}`);
                    $('.executeInvoiceDelete').attr('rel-payment', data.id);

                    let productsRows = ``;
                    let items = d.data.items;

                    for (let i = 0; i < items.length; i++) {
                        productsRows += `
                                    <tr class="items">
                                        <td>
                                            <input readonly type="text" value="${items[i].payment_method}" name="items[payment_method][]" class="payment_method form-control text-center" />
                                        </td>
                                        <td>
                                            <input readonly type="text" value="${items[i].box}" name="items[cashbox][]" class="cash_box form-control text-center" />
                                        </td>
                                        <td>
                                            <input readonly type="text" value="${items[i].payment_total}" name="items[sum][]" class="payment_sum form-control text-center" />
                                        </td>
                                        <td class="">
                                            <input readonly type="text" value="${items[i].bank_visa}" name="items[bank_visa][]" class="bank_visa form-control text-center" />
                                            <input readonly type="hidden" value="${items[i].bank_visa}" name="items[hidden_bank][]" class="hidden_bank form-control text-center"/>
                                        </td>
                                        <td class="">
                                            <input readonly type="text" value="${items[i].Branch_digits}" name="items[Branch_digits][]" class="Branch_digits form-control text-center" style="width: 100%;" />
                                            <input readonly type="hidden" value="${items[i].Branch_digits}" name="items[hidden_branch][]" class="hidden_branch form-control text-center"/>
                                        </td>
                                        <td class="">
                                            <input readonly type="text" value="" name="items[invoice_validity][]" class="invoice_validity form-control text-center" style="width: 100%;" />
                                        </td>
                                        <td class="">
                                            <input readonly type="text" value="${items[i].reference_number}" name="items[reference_id_num][]" class="reference_id_num form-control text-center" style="width: 100%;" />
                                        </td>
                                        <td class="">
                                            <input readonly type="text" value="${items[i].check_number}" name="items[check_number][]" class="check_number form-control text-center" style="width: 100%;" />
                                        </td>
                                        <td class="">   
                                            <input readonly type="text" value="${items[i].check_date}" name="items[check_date][]" class="datepicker check_date  form-control text-center "  style="width: 100%;" />
                                        </td>
                                    </tr>`;
                    }
                    $('#payment_table tbody').html(productsRows);
                    calcTotal();
                    $('#DeleteInvoice').modal('show');
                }
            }, 'json');
        }
    });
    $(document).on('click', '.cancel_invoice', function() {
        let elem = $(this);
        let data = {};
        $('#updatePayment').show();
        if (elem.attr("rel-payment") === "-1") {
            bootbox.alert("Please Select a payment from the table below to continue");
            $('#DeleteInvoice').modal('hide');
        } else {
            data = {
                id: elem.attr("rel-payment"),
            }

            $.post(root + 'admin/invoices/getSupplierPaymentData', data, function(d) {
                if (d.result == true) {
                    let data = d.data.payment_info;
                    $('#fill_invoice_code').val(`${data.id}`);
                    $('#fill_customer_credit').val(`${data.supplierCredit}`);
                    $('.invoiceCodeLabel').text(`${data.id}`);
                    $('#fill_invoice_date').val(`${data.payment_date}`);
                    $('#fill_boss_Comment').val(`${data.bossComment}`);
                    $('#fill_customer').val(`${data.customerName}`);
                    $('#fill_customer2').text(`${data.customerName}`);
                    $('.fill_cust_comment').val(`${data.custComment}`);
                    $('#fill_comment1').val(`${data.comment1}`);
                    $('#fill_comment2').val(`${data.comment2}`);
                    $('#fill_invoice_date1').val(`${data.dateCreation}`);
                    $('.executeInvoiceDelete').attr('rel-payment', data.id);

                    let productsRows = ``;
                    let items = d.data.items;

                    console.log(items[0]);

                    for (let i = 0; i < items.length; i++) {
                        productsRows += `
                            <tr class="items">
                                        <td>
                                            <input readonly type="text" value="${items[i].payment_method}" name="items[payment_method][]" class="payment_method form-control text-center" />
                                        </td>
                                        <td>
                                            <input readonly type="text" value="${items[i].box}" name="items[cashbox][]" class="cash_box form-control text-center" />
                                        </td>
                                        <td>
                                            <input readonly type="text" value="${items[i].payment_total}" name="items[sum][]" class="payment_sum form-control text-center" />
                                        </td>
                                        <td class="">
                                            <input readonly type="text" value="${items[i].bank_visa}" name="items[bank_visa][]" class="bank_visa form-control text-center" />
                                            <input readonly type="hidden" value="${items[i].bank_visa}" name="items[hidden_bank][]" class="hidden_bank form-control text-center"/>
                                        </td>
                                        <td class="">
                                            <input readonly type="text" value="${items[i].Branch_digits}" name="items[Branch_digits][]" class="Branch_digits form-control text-center" style="width: 100%;" />
                                            <input readonly type="hidden" value="${items[i].Branch_digits}" name="items[hidden_branch][]" class="hidden_branch form-control text-center"/>
                                        </td>
                                        <td class="">
                                            <input readonly type="text" value="" name="items[invoice_validity][]" class="invoice_validity form-control text-center" style="width: 100%;" />
                                        </td>
                                        <td class="">
                                            <input readonly type="text" value="${items[i].reference_number}" name="items[reference_id_num][]" class="reference_id_num form-control text-center" style="width: 100%;" />
                                        </td>
                                        <td class="">
                                            <input readonly type="text" value="${items[i].check_number}" name="items[check_number][]" class="check_number form-control text-center" style="width: 100%;" />
                                        </td>
                                        <td class="">   
                                            <input readonly type="text" value="${items[i].check_date}" name="items[check_date][]" class="datepicker check_date  form-control text-center "  style="width: 100%;" />
                                        </td>
                                    </tr>`;
                    }
                    $('#payment_table tbody').html(productsRows);
                    calcTotal();
                }
            }, 'json');

            $('#updatePayment').text('Delete Payment');
            $('#updatePayment').addClass('bg-danger');
        }


    });
    $('#updatePayment').on('click', function() {
        var data = $('#deleteInvoiceForm').serializeArray();
        $.post(root + 'admin/invoices/deleteSupplierPayment', data, function(d) {
            console.log(d);
            console.log(d.result);
            if (d.result == true) {
                alert("<?php echo $this->lang->line('Done'); ?>!");
                location.reload();
            } else {
                alert("<?php echo $this->lang->line('Error'); ?>!");
            }
        }, 'json');
    });
    $(document).on('change', '.Branch_digits', function(event) {
        let data = {};
        let elem = $(this);
        var row = elem.parent().parent();
        let id = elem.val();
        let bank_id = row.find(".hidden_bank").val();
        data.id = id;
        data.bank_id = bank_id;
        row.find(".hidden_branch").val(id);
        $.post(root + 'admin/invoices/getbranchDetails', data, function(d) {
            if (d.result == true) {
                elem.val(d.name);
                console.log(row.find(".hidden_branch").val());
            } else {
                elem.val("");
            }

        }, 'json');


    });
    $('#payment_for').on('change', function() {
        var data = {};
        data.supplier_id = $(this).val();
        $.post(root + 'admin/invoices/getSupplierDetailsforInvoice', data, function(d) {
            if (d.result == true) {
                $('#customer_credit').val(d.credit);
            } else {
                $('#customer_credit').val("");
            }

        }, 'json');
    });
    $('#add_item').on('click', function() {
        var $table = $('#payment_table');
        var last = $('tr.items:last');
        var sum = 0;
        var bank_visa = "";
        var brach_digits = 0;
        var invoice_validity = 0;
        var check_number = 0;
        var check_date = "";
        var bank_visa_code = 0;
        var brach_digits_code = 0;
        var approve_number = 0;
        var method = last.find(".payment_method").val();
        if (method == 3) {
            sum = last.find(".payment_sum").val();
        } else if (method == 1) {
            sum = last.find(".payment_sum").val();
            bank_visa = last.find(".bank_visa").val();
            brach_digits = last.find(".Branch_digits").val();
            bank_visa_code = last.find(".hidden_bank").val();
            // console.log(bank_visa_code);
            brach_digits_code = last.find(".hidden_branch").val();
            // console.log(brach_digits_code);
            invoice_validity = last.find(".invoice_validity").val();
            check_date = last.find(".check_date").val();
            // check_date = new Date(check_date);
            approve_number = last.find(".reference_id_num").val();

        } else if (method == 5) {
            sum = last.find(".payment_sum").val();
            bank_visa = last.find(".bank_visa").val();
            brach_digits = last.find(".Branch_digits").val();
            brach_digits_code = last.find(".hidden_branch").val();
            bank_visa_code = last.find(".hidden_bank").val();
            // console.log(bank_visa_code);
            // console.log(brach_digits_code);
            invoice_validity = last.find(".invoice_validity").val();
            check_date = last.find(".check_date").val();
            check_date = new Date(check_date);
            check_number = last.find(".check_number").val();
            check_number = Number(check_number);
        } else {
            sum = last.find(".payment_sum").val();
            bank_visa = last.find(".bank_visa").val();
            brach_digits = last.find(".Branch_digits").val();
            bank_visa_code = last.find(".hidden_bank").val();
            // console.log(bank_visa_code);
            brach_digits_code = last.find(".hidden_branch").val();
            // console.log(brach_digits_code);
            invoice_validity = last.find(".invoice_validity").val();
            check_date = last.find(".check_date").val();
            check_date = new Date(check_date);
            approve_number = last.find(".reference_id_num").val();
        }

        let newRow = `
                    <tr class="items">
                        <td style="width: 5px;">
                            <div href="#0" class="remove_this_item btn btn-sm bg-danger text-white p-1">
                                <i class="fa fa-times"></i>
                            </div>
                        </td>
                        <td>
                            <select style="width:100px;" name="items[payment_method][]" class="payment_method">
                                <option value="0">נא בחר</option>
                                <?php foreach ($payment_types as $payment_type) { ?>
                                    <option value="<?php echo $payment_type->type_id; ?>"><?php echo $payment_type->name; ?></option>
                                <?php }; ?>
                            </select>
                        </td>
                        <td>
                            <select style="width:100px;" name="items[cashbox][]" class="cash_box">
                                <option value="0">נא בחר</option>
                                <?php foreach ($payment_boxes as $payment_box) { ?>
                                    <option value="<?php echo $payment_box->box_id; ?>"><?php echo $payment_box->name; ?></option>
                                <?php }; ?>
                            </select>
                        </td>
                        <td>
                            <input type="text" value="" name="items[sum][]" class="payment_sum form-control text-center" />
                        </td>
                        <td class="check_items shared_items">
                            <input type="text" value="" name="items[bank_visa][]" class="bank_visa form-control text-center" />
                            <input type="hidden" value="" name="items[hidden_bank][]" class="hidden_bank form-control text-center"/>
                        </td>
                        <td class="check_items shared_items">
                            <input type="text" value="" name="items[Branch_digits][]" class="Branch_digits form-control text-center" style="width: 100%;" />
                            <input type="hidden" value="" name="items[hidden_branch][]" class="hidden_branch form-control text-center"/>
                        </td>
                        <td class="check_items shared_items">
                            <input type="text" value="" name="items[invoice_validity][]" class="invoice_validity form-control text-center" style="width: 100%;" />
                        </td>
                        <td class="bank_items">
                            <input type="text" value="" name="items[reference_id_num][]" class="reference_id_num form-control text-center" style="width: 100%;" />
                        </td>
                        <td class="check_items">
                            <input type="text" value="" name="items[check_number][]" class="check_number form-control text-center" style="width: 100%;" />
                        </td>
                        <td class="check_items shared_items">
                            <input type="text" value="" name="items[check_date][]" class="datepicker check_date  form-control text-center "  style="width: 100%;" />
                        </td>
                    </tr>`;

        $(newRow).insertBefore('#btns_group');
        var new_row = $('tr.items:last');

        if (method == 3) {
            new_row.find(".cash_box").val('4');
            new_row.find(".payment_method").val('3');
            new_row.find(".payment_sum").val(sum);
        } else if (method == 0) {
            new_row.find(".cash_box").val('0');
            new_row.find(".payment_method").val('0');
            new_row.find('.bank_items').hide();
            $('#payment_table thead').find('.bank_items').hide();
        } else if (method == 1) {
            new_row.find(".cash_box").val('1');
            new_row.find(".payment_method").val('1');
            new_row.find(".check_items").hide();
            new_row.find('.bank_items').show();
            new_row.find(".shared_items").show();
            $('#payment_table thead').find('.check_items').hide();
            $('#payment_table thead').find('.bank_items').show();
            $('#payment_table thead').find('.shared_items').show();
            new_row.find(".payment_sum").val(sum);
            new_row.find(".bank_visa").val(bank_visa);
            new_row.find(".Branch_digits").val(brach_digits);
            new_row.find(".hidden_branch").val(brach_digits_code);
            new_row.find(".hidden_bank").val(bank_visa_code);
            new_row.find(".hidden_branch").val(brach_digits_code);
            new_row.find(".invoice_validity").val(invoice_validity);
            //new_row.find(".check_date").val(check_date);
            new_row.find(".reference_id_num").val(approve_number);
        } else if (method == 5) {
            new_row.find(".cash_box").val('16');
            new_row.find(".payment_method").val('5');
            new_row.find(".cash_box").val('16');
            new_row.find(".check_items").show();
            new_row.find('.bank_items').hide();
            new_row.find(".shared_items").show();
            $('#payment_table thead').find('.bank_items').hide();
            $('#payment_table thead').find('.check_items').show();
            $('#payment_table thead').find('.shared_items').show();
            new_row.find(".payment_sum").val(sum);
            new_row.find(".bank_visa").val(bank_visa);
            new_row.find(".Branch_digits").val(brach_digits);
            new_row.find(".hidden_bank").val(bank_visa_code);
            new_row.find(".hidden_branch").val(brach_digits_code);
            new_row.find(".invoice_validity").val(invoice_validity);
            //new_row.find(".check_date").val(check_date);
            new_row.find(".check_number").val(check_number + 1);

            let newDate = last.find(".check_date").datepicker({
                dateFormat: "dd/mm/yy",
            });

            let newRow_dateInput = new_row.find(".check_date");
            newRow_dateInput.datepicker({
                dateFormat: "dd/mm/yy",
                isRTL: true,
                prevText: '<i class="fa fa-chevron-trash"></i>',
                nextText: '<i class="fa fa-chevron-right"></i>',
            });

            newDate = last.find(".check_date").datepicker('getDate');
            console.log(newDate);
            newRow_dateInput.val(newDate);
            newRow_dateInput.datepicker('setDate', "+1m");
        } else {
            new_row.find(".check_items").hide();
            new_row.find(".cash_box").val('1');
            new_row.find(".payment_method").val('1');
            new_row.find(".check_items").hide();
            new_row.find('.bank_items').show();
            new_row.find(".shared_items").show();
            $('#payment_table thead').find('.check_items').hide();
            $('#payment_table thead').find('.bank_items').show();
            $('#payment_table thead').find('.shared_items').show();
            new_row.find(".payment_sum").val(sum);
            new_row.find(".bank_visa").val(bank_visa);
            new_row.find(".Branch_digits").val(brach_digits);
            new_row.find(".hidden_branch").val(brach_digits_code);
            new_row.find(".hidden_bank").val(bank_visa_code);
            new_row.find(".hidden_branch").val(brach_digits_code);
            new_row.find(".invoice_validity").val(invoice_validity);
            //new_row.find(".check_date").val(check_date);
            new_row.find(".reference_id_num").val(approve_number);
        }

        $('.datepicker').datepicker({
            dateFormat: "dd/mm/yy",
            isRTL: true,
            prevText: '<i class="fa fa-chevron-trash"></i>',
            nextText: '<i class="fa fa-chevron-right"></i>',
        });
        calcTotal();
    });

    $(document).on('change', '.payment_method', function(event) {
        var elem = $(this);
        var row = elem.parent().parent();
        let method = elem.val();
        row.find(".check_items").hide();
        row.find('.bank_items').hide();
        row.find(".shared_items").hide();
        // $('#payment_table thead').find('.bank_items').hide();
        // $('#payment_table thead').find('.check_items').hide();
        // $('#payment_table thead').find('.shared_items').hide();
        if (method == 3) {
            // $("#cash_box option[value='Gateway 2']").prop('selected', true);
            row.find(".cash_box").val('4');
            row.parent().parent().parent().parent().parent().parent().parent().parent().parent().parent().addClass('modal-xl');
        } else if (method == 0) {
            row.find(".cash_box").val('0');
            row.find('.bank_items').hide();
            $('#payment_table thead').find('.bank_items').hide();
            row.parent().parent().parent().parent().parent().parent().parent().parent().parent().parent().addClass('modal-xl');
        } else if (method == 1) {
            row.find(".cash_box").val('1');
            row.find(".check_items").hide();
            row.find('.bank_items').show();
            row.find(".shared_items").show();
            $('#payment_table thead').find('.check_items').hide();
            $('#payment_table thead').find('.bank_items').show();
            $('#payment_table thead').find('.shared_items').show();
            row.find("input").val("");
            row.find(".check_date").val(moment().format('MMM D, YYYY'));
            row.parent().parent().parent().parent().parent().parent().parent().parent().parent().parent().addClass('modal-xl');
        } else if (method == 5) {
            row.find(".cash_box").val('16');
            row.find(".check_items").show();
            row.find('.bank_items').hide();
            row.find(".shared_items").show();
            $('#payment_table thead').find('.bank_items').hide();
            $('#payment_table thead').find('.check_items').show();
            $('#payment_table thead').find('.shared_items').show();
            row.find("input").val("");
            row.parent().parent().parent().parent().parent().parent().parent().parent().parent().parent().addClass('modal-xl');
        } else {
            row.find(".cash_box").val('1');
            row.find(".check_items").hide();
            row.find('.bank_items').show();
            row.find(".shared_items").show();
            $('#payment_table thead').find('.check_items').hide();
            $('#payment_table thead').find('.bank_items').show();
            $('#payment_table thead').find('.shared_items').show();
            row.find("input").val("");
            row.find(".check_date").val(moment().format('MMM D, YYYY'));
            row.parent().parent().parent().parent().parent().parent().parent().parent().parent().parent().addClass('modal-xl');
        }

    });
    $(document).on('change', '.payment_sum', function(event) {
        calcTotal();
    });
    $('.datepicker').datepicker({
        dateFormat: "dd/mm/yy",
        isRTL: true,
        prevText: '<i class="fa fa-chevron-trash"></i>',
        nextText: '<i class="fa fa-chevron-right"></i>',
    });
    $(document).on('click', '.next-stage', function(event) {
        let checkArray = [];
        let elem = $(this);
        let isDeleteModal = elem.attr('rel-delete') === "true" ? true : false;
        let parentPageOne = elem.parent().parent();
        let inputArray = parentPageOne.find('input');
        $.each(inputArray, function(index, el) {
            let elName = el.getAttribute('name');
            if (elName == "boss_Comment" || elName == "custComment") {
                checkArray.push(true);
            } else {
                if (el.value == "" || el.value == 0 || el.value == -1) {
                    checkArray.push(false);
                    el.classList.add('is-invalid');
                } else {
                    el.classList.add('is-valid');
                    checkArray.push(el.value);
                }
            }
        });
        if (!isDeleteModal) {
            $.each($('#payment_for'), function(index, el) {
                if (el.value == 0 ||
                    el.value == "" ||
                    el.value == undefined ||
                    el.value == null ||
                    el.value < 0) {
                    checkArray.push(false);
                    el.parentElement.style.border = "2px solid red";
                    el.parentElement.style.borderRadius = "5px";
                } else {
                    el.parentElement.style.border = "2px solid green";
                    el.parentElement.style.borderRadius = "5px";
                    checkArray.push(el.value);
                }
            });
        }
        if ($.inArray(false, checkArray) !== -1) {
            console.log('you forgot an input');
        } else {
            let date = $("#payment_date").val();
            let comment = $("#custComment").val();
            let credit = $("#customer_credit").val();
            let customer = $('#payment_for').find('option:selected').text();
            let elem = $(this);
            elem.parent().parent().parent().find('page').show();
            $("#customer").html("לקוח: " + customer);
            $("#cust_comment").val(comment);
            $("#payment_date1").val(date);
            $("#credit1").val(credit);
            let parentModal = parentPageOne.parent().parent().parent().parent().parent();
            parentModal.addClass('modal-xl');
            elem.parent().parent().hide();
        }

    });
    $('.reverse-stage').on('click', function() {
        let elem = $(this);
        let isDeleteModal = elem.attr('rel-delete') === "true" ? true : false;

        if (isDeleteModal) {
            $('#DeleteInvoice .modal-dialog').removeClass('modal-lg');
        } else {
            $('#myModal .modal-dialog').removeClass('modal-lg');
        }
        elem.parent().parent().parent().parent().parent().parent().parent().parent().parent().parent().removeClass('modal-xl');
        elem.parent().parent().parent().parent().parent().parent().find('.first-stage').show();
        elem.parent().parent().parent().parent().parent().hide();
    });
    $(document).on('click', '.remove_this_item', function() {
            var elem = $(this);
            var items = $(this).parent().parent().parent().find('tr.items').length;
            if( items <= 1 ){
                elem.parent().parent().find('input, select').val("");
            }else{
                elem.parent().parent().remove();
            }
            calcTotal();
            itemAddition--;
        });

    $(document).on('click', '#close_invoiceForm, #close_modal, #close_DeleteModal, #close_ExportModal', function() {
        let elem = $(this);
        let isDeleteModal = elem.attr('rel-delete') === "true" ? true : false;

        let isExportModal = elem.attr('rel-export') === "true" ? true : false;

        if (isExportModal) {
            $('#ExcelExportModal').modal('hide');
        }

        if (isDeleteModal) {
            $('#DeleteInvoice').modal('hide');
            $('#DeleteInvoice').find('modal-dialog').removeClass('modal-lg');
        } else {
            $('#myModal').modal('hide');
            $('#DeleteInvoice').find('modal-dialog').removeClass('modal-lg');
        }
    });

    function calcTotal() {
        var full_total = 0;
        $(".payment_sum ").each(function(index) {
            var elem = $(this);
            var sum = Number(elem.val());

            full_total += sum;
        });
        var before_vat = full_total / 1.17;
        var vat = full_total - before_vat;
        $('.fill_total_before_vat').val(before_vat.toFixed(2));
        $('.fill_vat').val(vat.toFixed(2));
        $('.fill_total').val(full_total.toFixed(2));
    }
</script>



<!-- <script src="<?php echo site_url(); ?>assets/js/customerInvoice.js"></script> -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootbox.js/5.5.2/bootbox.min.js" integrity="sha512-RdSPYh1WA6BF0RhpisYJVYkOyTzK4HwofJ3Q7ivt/jkpW6Vc8AurL1R+4AUcvn9IwEKAPm/fk7qFZW3OuiUDeg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<!-- <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.0/js/bootstrap-datepicker.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.0/css/bootstrap-datepicker.css"> -->
<script>
    $(document).ready(function() {
        $('#send_between').on('click', function() {
            var payment_id = $(this).attr('rel-id');
            $('#payment_id').val(payment_id);
            $('#convert_box').modal('show');
        });

        $('#convert_box_data').on('click', function() {
            var data = {};
            data.payment_id = $('#payment_id').val();
            data.new_box = $('#new_payment_box').val();
            data.new_payment = $('#new_payment_type').val();

            $.post(root + 'admin/invoices/supplierconvertPayment', data, function(d) {

                if (d.result == true) {
                    alert("<?php echo $this->lang->line('Done'); ?>!");
                    location.reload();
                } else {
                    alert("<?php echo $this->lang->line('Error'); ?>!");
                }

            }, 'json');
        });



    });
</script>
<style>
    table#supPaymentTable {
        width: 100% !important;
    }
</style>