<?php
if (
    !isset($permissions['suppliers']['payments'])
    || isset($permissions['suppliers']['payments'])
    && $permissions['suppliers']['payments'] == 0
) redirect('admin/dashboard');
?>
<script src="//cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script src="<?php echo site_url(); ?>assets/js/plugin/datatables/dataTables.colReorder.min.js"></script>
<script src="<?php echo site_url(); ?>assets/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="<?php echo site_url(); ?>assets/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="<?php echo site_url(); ?>assets/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="<?php echo site_url(); ?>assets/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>

<script src="//cdn.datatables.net/buttons/1.6.1/js/dataTables.buttons.min.js" crossorigin="anonymous"></script>
<script src="//cdn.datatables.net/buttons/1.6.1/js/buttons.flash.min.js" crossorigin="anonymous"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js" crossorigin="anonymous"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js" crossorigin="anonymous"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js" crossorigin="anonymous"></script>
<script src="//cdn.datatables.net/buttons/1.6.1/js/buttons.html5.min.js" crossorigin="anonymous"></script>
<script src="//cdn.datatables.net/buttons/1.6.1/js/buttons.print.min.js" crossorigin="anonymous"></script>
<script src="//cdn.datatables.net/buttons/1.6.1/js/buttons.colVis.min.js" crossorigin="anonymous"></script>
<!-- MAIN PANEL -->
<div id="main" role="main">
    <div id="content" style=" padding-top: 0px; ">

        <div class="row">

            <div class="col col-lg-12 table-responsive">
                <br />
                <h1>
                    <?php echo $this->lang->line('invoices_payments_from'); ?>
                    <strong><?php echo date('d/m/Y', strtotime($from)); ?></strong>
                    <?php echo $this->lang->line('until'); ?>
                    <strong><?php echo date('d/m/Y', strtotime($to)); ?></strong>
                </h1>
                <br />
                <br />
            </div>

            <div class="col-lg-12">
                <div class="well">
                    <form class="" method="POST">
                        <fieldset>
                            <div class="row">
                                <div class="col-sm-2">

                                    <div class="form-group">
                                        <label class="">&nbsp;</label>
                                        <div class="input">
                                            <input class="form-control text-center" name="from" id="from" type="text" value="<?php echo date('d/m/Y', strtotime($from)); ?>" autocomplete="off" style="width: 100%;" />

                                        </div>
                                    </div>

                                </div>
                                <div class="col-sm-2">

                                    <div class="form-group">
                                        <label class="">&nbsp;</label>
                                        <div class="input">
                                            <input class="form-control text-center" name="to" id="to" type="text" value="<?php echo date('d/m/Y', strtotime($to)); ?>" autocomplete="off" style="width: 100%;" />

                                        </div>
                                    </div>

                                </div>
                                <div class="col-sm-2" style="margin-top: 24px;">
                                    <div class="form-group">
                                        <button class="btn btn-danger" type="submit"><i class="fa fa-search"></i><?php echo $this->lang->line('search'); ?></button>
                                        <button class="btn btn-default" type="button" onclick="clearAll();"><i class="fa fa-eraser"></i><?php echo $this->lang->line('clean_all'); ?></button>
                                    </div>
                                </div>
                            </div>
                        </fieldset>
                    </form>
                </div>
                <br />
                <br />
            </div>

            <div class="col-lg-9">
                <table class="table table-bordered" id="dt_basic2">
                    <thead>
                        <th></th>
                        <th><?php echo $this->lang->line('date'); ?></th>
                        <th>#</th>
                        <th><?php echo $this->lang->line('telephone'); ?></th>
                        <th><?php echo $this->lang->line('company'); ?></th>
                        <th><?php echo $this->lang->line('auth_number'); ?></th>
                        <th><?php echo $this->lang->line('balance_credit'); ?></th>
                        <th><?php echo $this->lang->line('debit'); ?></th>
                        <th><?php echo $this->lang->line('balance'); ?></th>
                    </thead>
                    <tbody>
                        <?php $dynamic_balance = $balance;
                        $i = 0; ?>
                        <?php foreach ($supplier_used_details as $supplier_details) {
                            $i++ ?>
                            <tr>
                                <td><?php echo $i; ?></td>
                                <td><?php echo date('d/m/Y - H:i', strtotime($supplier_details->order_date)); ?></td>
                                <td><?php echo $supplier_details->order_id; ?></td>
                                <td><?php echo $supplier_details->phone; ?></td>
                                <td><?php echo $supplier_details->company; ?></td>
                                <td>
                                    <?php
                                    $data = array(" - Success", "Success - ", "Succsess ", "Succsess");
                                    $api_result = str_replace($data, "", $supplier_details->api_result);
                                    echo $api_result;
                                    ?>
                                </td>
                                <td class="edit_this" <?php if (isset($supplier_details->price_after)) { ?> rel="<?php echo $supplier_details->id; ?>" rel-type="<?php if (isset($supplier_details->price_after)) {
                                                                                                                                                                        echo 'payment';
                                                                                                                                                                    }; ?>" <?php }; ?>>
                                    <?php if (isset($supplier_details->price_after)) { ?>
                                        <?php echo number_format($supplier_details->price_after, 2); ?>
                                    <?php }; ?>
                                </td>
                                <td class="edit_this" <?php if (isset($supplier_details->invoice)) { ?> rel="<?php echo $supplier_details->id; ?>" rel-type="<?php if (isset($supplier_details->invoice)) {
                                                                                                                                                                    echo 'invoice';
                                                                                                                                                                }; ?>" <?php }; ?>>
                                    <?php if (isset($supplier_details->invoice)) { ?>
                                        <?php echo number_format(($supplier_details->invoice * -1), 2); ?>
                                    <?php }; ?>
                                </td>
                                <td>
                                    <?php

                                    if (isset($supplier_details->price_after)) {
                                        $dynamic_balance -= $supplier_details->price_after;
                                    }

                                    if (isset($supplier_details->invoice)) {
                                        $dynamic_balance += $supplier_details->invoice;
                                    }

                                    echo number_format($dynamic_balance, 2);
                                    ?>
                                </td>
                            </tr>
                        <?php }; ?>
                    </tbody>
                    <tfoot>
                        <?php $full_total = 0; ?>
                        <?php foreach ($companies_count as $count) {
                            $full_total += $count->total;
                        }; ?>
                        <?php $full_total2 = 0; ?>
                        <?php foreach ($supplier_invoices as $supplier_invoice) {
                            $full_total2 += $supplier_invoice->invoice_total;
                        }; ?>
                        <tr>
                            <td colspan="6" class="text-left"><?php echo $this->lang->line('total'); ?></td>
                            <td><strong><?php echo number_format($full_total, 2); ?></strong></td>
                            <td><strong><?php echo number_format($full_total2, 2); ?></strong></td>
                            <td></td>
                        </tr>
                    </tfoot>
                </table>
            </div>

            <div class="col-lg-3">

                <div class="well">
                    <h2>
                        <?php echo $this->lang->line('payments_and_transfers'); ?>
                    </h2>
                    <hr />
                    <table class="table table-bordered table-consered">
                        <thead>
                            <th><?php echo $this->lang->line('invoices_num'); ?></th>
                            <th><?php echo $this->lang->line('sum'); ?></th>
                            <th><?php echo $this->lang->line('date'); ?></th>
                        </thead>
                        <tbody>
                            <?php $full_total2 = 0; ?>
                            <?php foreach ($supplier_invoices as $supplier_invoice) { ?>
                                <tr>
                                    <td><?php echo $supplier_invoice->invoice_number; ?></td>
                                    <td><?php $full_total2 += $supplier_invoice->invoice_total;
                                        echo number_format($supplier_invoice->invoice_total, 2); ?></td>
                                    <td><?php echo date('d/m/Y', strtotime($supplier_invoice->invoice_date)); ?></td>
                                </tr>
                            <?php }; ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="2" class="text-right"><strong><?php echo $this->lang->line('total'); ?></strong></td>
                                <td><strong><?php echo number_format($full_total2, 2); ?></strong></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>

                <div class="well">
                    <h2>
                        <?php echo $this->lang->line('sum_of_results'); ?>
                    </h2>
                    <hr />
                    <table class="table table-bordered table-consered">
                        <thead>
                            <th><?php echo $this->lang->line('company'); ?></th>
                            <th><?php echo $this->lang->line('quantity'); ?></th>
                            <th><?php echo $this->lang->line('sum'); ?></th>
                        </thead>
                        <tbody>
                            <?php $full_total = 0; ?>
                            <?php foreach ($companies_count as $count) { ?>
                                <tr>
                                    <td><?php echo $count->company; ?></td>
                                    <td><?php echo $count->Count; ?></td>
                                    <td><?php $full_total += $count->total;
                                        echo number_format($count->total, 2); ?></td>
                                </tr>
                            <?php }; ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="2" class="text-right"><strong><?php echo $this->lang->line('total'); ?></strong></td>
                                <td><strong><?php echo number_format($full_total, 2); ?></strong></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>

            </div>
        </div>
    </div>
</div>
<style>
    #dt_basic2_wrapper {
        float: none !important;
    }

    .dt-buttons {
        float: left;
        text-align: right;
    }

    .dt-button {
        background: transparent;
        border: 1px solid #a90329;
        padding: 5px;
        padding-right: 20px;
        padding-left: 20px;
        font-weight: bold;
        border-radius: 25px;
        color: #a90329;
    }

    .dt-button-collection .dt-button {
        background: #ffffff;
        float: right;
        opacity: 0.5;
    }

    .dt-button-collection {
        margin-top: 7px;
        position: absolute;
        z-index: 9999;
        background: #0000007a;
        width: 140%;
        right: 100px;
        padding: 7px;
        border-radius: 25px;
    }

    button.dt-button.buttons-columnVisibility.active {
        background: white;
        opacity: 1;
    }
</style>
<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js" integrity="sha512-qTXRIMyZIFb8iQcfjXWCO8+M5Tbc38Qi5WzdPOYZHIlZpzBHG3L3by84BBBOiRGiEb7KKtAOAs5qYdUiZiQNNQ==" crossorigin="anonymous"></script>
<script src="https://cdn.datatables.net/plug-ins/1.10.15/sorting/datetime-moment.js"></script>

<script type="text/javascript">
    <?php
    $url = '';
    if ($this->session->userdata('site_lang') == 'hebrew') {
        $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Hebrew.json';
    } else if ($this->session->userdata('site_lang') == 'arabic') {
        $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Arabic.json';
    } else if ($this->session->userdata('site_lang') == 'english') {
        $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json';
    } else {
        $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Hebrew.json';
    }
    ?>
    $.fn.dataTable.moment('DD/MM/YYYY - HH:mm');
    $(document).ready(function() {

        var oTbl1 = $('#dt_basic2').DataTable({
            "sDom": "<'dt-toolbar'<'col-xs-12 col-sm-8'f><'dt-buttons col-sm-4 col-xs-12 hidden-xs'l>r>" +
                "t" +
                "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-xs-12 col-sm-6'p>>",
            "buttons": ['copyHtml5', 'excelHtml5', 'csvHtml5', 'colvis'],
            "processing": true,
            "order": [
                [0, "desc"]
            ],
            "bStateSave": false,
            "dom": 'Bfrtip',
            "pagingType": "full_numbers",
            "lengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "<?php echo $this->lang->line('Everything'); ?>"]
            ],
            "pageLength": 10,
            "sPaginationType": "full_numbers",
            "iDisplayLength": 10,
            "language": {
                "url": "<?php echo $url; ?>"
            },
            orderCellsTop: true,
            fixedHeader: true,
            columnDefs: [{
                target: 1,
                type: 'datetime-moment'
            }]
        });

        $("#from").datepicker({
            dateFormat: 'dd/mm/yy',
            defaultDate: "now",
            changeMonth: true,
            numberOfMonths: 2,
            isRTL: true,
            prevText: '<i class="fa fa-chevron-left"></i>',
            nextText: '<i class="fa fa-chevron-right"></i>',
            onClose: function(selectedDate) {
                $("#firstPayToDate").datepicker("option", "minDate", selectedDate);
            }
        });
        $("#to").datepicker({
            dateFormat: 'dd/mm/yy',
            defaultDate: "now",
            changeMonth: true,
            numberOfMonths: 2,
            isRTL: true,
            prevText: '<i class="fa fa-chevron-left"></i>',
            nextText: '<i class="fa fa-chevron-right"></i>',
            onClose: function(selectedDate) {
                $("#firstPayDate").datepicker("option", "maxDate", selectedDate);
            }
        });

        oTbl1.buttons().container().appendTo('.dataTables_filter');

        $('input[aria-controls="dt_basic2"]').attr('placeholder', '<?php echo $this->lang->line('search1'); ?>...');

        $('#dt_basic2_info').css('float', 'left').parent().css('float', 'left');
        $('.dataTables_paginate ').parent().css('float', 'right');
        $('.dataTables_paginate ').css('text-align', 'right');

        $(document).on('dblclick', '.edit_this', function() {
            if ($(this).find('.new_input').length === 0) {
                var id = $(this).attr("rel");
                var type = $(this).attr("rel-type");
                var elem = $(this);
                var val = $.trim($(this).text());

                if (typeof id !== typeof undefined && id !== false && typeof type !== typeof undefined && type !== false) {
                    elem.html();
                    elem.html("<input type='text' class='new_input form-control' value='" + val + "' rel='" + id + "' rel-type='" + type + "' style='padding-left: 0; width: 80px;' /> <a href='#0' class='edit_amount btn btn-success btn-circle btn-xs'><i class='fa fa-check'></i></a>  <a href='#0' class='remove_this btn btn-danger btn-circle btn-xs'><i class='fa fa-times'></i></a> ");
                }
            }
        });

        $(document).on('click', '.remove_this', function() {
            var td = $(this).parent();
            var input = $(this).parent().find('input');
            var val = input.val();
            td.html("");
            td.html(val);
        });

        $(document).on('click', '.edit_amount', function() {
            var td = $(this).parent();
            var input = $(this).parent().find('input');
            var val = input.val();
            var data = {};
            data.id = input.attr("rel");
            data.type = input.attr("rel-type");
            data.amount = val;

            $.post(root + 'admin/suppliers/updatePayment', data, function(d) {
                if (d.result == true) {
                    $.smallBox({
                        title: "<?php echo $this->lang->line('successfully_updated'); ?>",
                        content: d.note,
                        color: "#739E73",
                        iconSmall: "fa fa-thumbs-up bounce animated",
                        timeout: 2500
                    });
                } else {
                    alert("<?php echo $this->lang->line('Error'); ?>");
                    location.reload();
                }

            }, 'json');

            td.html("");
            td.html(val);
        });

        $('.new_input').dblclick(function() {
            return false;
            $(this).focus();
        });

    });
</script>