<div id="main" role="main">
	<div id="content" class="p-3">
		<div class="row">
			<div class="col-xs-12 col-sm-7 col-md-7 col-lg-4">
				<h1 class="page-title txt-color-blueDark">
					<i class="fa fa-user fa-fw "></i>
					<?php echo $this->lang->line('users'); ?>
					<span>>
						<?php print $mode ?> <?php echo $this->lang->line('user'); ?>
					</span>
				</h1>
			</div>
		</div>
		<?php if ($this->session->flashdata('flashMsgType') == 'Success') : ?>
			<div class="alert alert-success in"><button class="close" data-dismiss="alert">×</button><i class="fa-fw fa fa-check"></i>
				<strong><?php print $this->session->flashdata('flashMsgType') ?></strong> <?php print $this->session->flashdata('flashMsg') ?>
			</div>
		<?php elseif ($this->session->flashdata('flashMsgType') == 'Error') : ?>
			<div class="alert alert-danger in"><button class="close" data-dismiss="alert">×</button><i class="fa-fw fa fa-times"></i>
				<strong><?php print $this->session->flashdata('flashMsgType') ?></strong> <?php print $this->session->flashdata('flashMsg') ?>
			</div>
		<?php endif; ?>
		<div class="row">
			<div class="col-lg-6 col-md-6 col-sm-10 col-xs-10 mx-auto customerFormBg">
				<h2>
					<i class="fas fa-user-circle"></i>
					<?php echo $this->lang->line('user_details'); ?>
				</h2>

				<form id="user-form" novalidate="novalidate" method="post" action="<?php print site_url(); ?>admin/users/userAction" autocomplete="OFF">
					<input type="hidden" id="userId" name="userId" value="<?php print $user->userId ?>" />

					<hr>
					<div class="row justify-content-between">
						<div class="col-lg-12 col-md-12 col-sm-12 mb-2">
							<label class="form-label"><?php echo $this->lang->line('username'); ?></label>
							<input type="text" class="form-control" name="username" placeholder="<?php echo $this->lang->line('username'); ?>" value="<?php print $user->username ?>">
						</div>
						<div class="col-lg-6 col-md-6 col-sm-12 mb-2">
							<label class="form-label"><?php echo $this->lang->line('first_name'); ?></label>
							<input type="text" class="form-control" name="firstname" placeholder="<?php echo $this->lang->line('first_name'); ?>" value="<?php print $user->firstname ?>">
						</div>
						<div class="col-lg-6 col-md-6 col-sm-12 mb-2">
							<label class="form-label"><?php echo $this->lang->line('last_name'); ?></label>
							<input type="text" class="form-control" name="lastname" placeholder="<?php echo $this->lang->line('last_name'); ?>" value="<?php print $user->lastname ?>">
						</div>

						<div class="col-lg-6 col-md-6 col-sm-12 mb-2">
							<label class="form-label"><?php echo $this->lang->line('mail'); ?></label>
							<input type="email" name="email" class="form-control" placeholder="<?php echo $this->lang->line('mail'); ?>" value="<?php print $user->email ?>" <?php if ($mode == 'Edit') print 'disabled="disabled"' ?> />
						</div>

						<div class="col-lg-6 col-md-6 col-sm-12 mb-2">
							<label class="form-label"><?php echo $this->lang->line('telephone'); ?></label>
							<input type="tel" name="phone" class="form-control" placeholder="<?php echo $this->lang->line('telephone'); ?>" data-mask="999-999-9999" value="<?php print $user->phone ?>">
						</div>

						<div class="col-lg-6 col-md-6 col-sm-12 mb-2">
							<label class="form-label"><?php echo $this->lang->line('password'); ?></label>
							<input class="form-control" type="password" name="password" autocomplete="new-password" placeholder="<?php echo $this->lang->line('password'); ?>" id="password" value="">
							<b class="tooltip tooltip-bottom-right"><?php echo $this->lang->line('keep_password_save'); ?></b>
						</div>

						<div class="col-lg-6 col-md-6 col-sm-12 mb-2">
							<label class="form-label"><?php echo $this->lang->line('password'); ?></label>
							<input class="form-control" type="password" name="passwordConfirm" autocomplete="new-password" placeholder="<?php echo $this->lang->line('new_password'); ?>" value="">
							<b class="tooltip tooltip-bottom-right"><?php echo $this->lang->line('keep_password_save'); ?></b>
						</div>
						
						<div class="col-lg-6 col-md-6 col-sm-12 mb-2">
							<label class="form-label"><?php echo $this->lang->line('type'); ?></label>
							<select name="userType mb-3">
        						<?php foreach ($userTypes as $ut) : ?>
        							<option value="<?php print $ut->utId ?>" <?php if ($user->userLevel == $ut->utId) print 'selected="selected"' ?>><?php print $ut->title ?></option>
        						<?php endforeach; ?>
        					</select>
						</div>
						<?php if ($user->userLevel != 3) { ?>
						    <div class="col-lg-6 col-md-6 col-sm-12 mb-2">
							    <label class="form-label"><?php echo $this->lang->line('cashbox'); ?></label>
        						<select name="payment_box mb-3">
        							<option value=""></option>
        							<?php foreach ($payment_boxes as $box) : ?>
        								<option value="<?php print $box->box_id ?>" <?php if ($user->payment_box == $box->box_id) print 'selected="selected"' ?>><?php print $box->name ?></option>
        							<?php endforeach; ?>
        						</select>
						    </div>
    					<?php }; ?>
    					<div class="col-lg-12 col-md-12 col-sm-12 mb-2">
        					<div class="form-check">
						        <input type="checkbox" name="isActive" id="isActive" <?php if ($user->isActive == 1 || $user->isActive == '') print 'checked="checked"'; ?> />
                                <label class="form-check-label" for="isActive">
                                    <?php echo $this->lang->line('active'); ?>
                                </label>
                            </div>
                        </div>
					    <?php if ((getUserId() == 2 || getUserId() == 785) && $mode == 'עריכת') { ?>
					        <div class="col-lg-12 col-md-12 col-sm-12 mb-2">
            					<div class="form-check">
							        <input type="checkbox" name="view_permissions" id="view_permissions" <?php if ($user->view_permissions == 1) print 'checked="checked"'; ?> />
                                    <label class="form-check-label" for="view_permissions">
                                        <?php echo $this->lang->line('permissions'); ?>
                                    </label>
                                </div>
                            </div>
					    <?php }; ?>
					</div>
					<footer class="d-flex justify-content-between mt-3">
						<div>
							<a class="btn btn-sm btn-dark rounded-pill shadow" title="<?php echo $this->lang->line('all_users'); ?>" href="<?php print site_url(); ?>admin/users">
								<i class="fa fa-user me-1"></i>
								<?php echo $this->lang->line('all_users'); ?>
							</a>
						</div>
						<button type="submit" class="btn btn-sm rounded-pill shadow btn-primary pull-right"><?php echo $this->lang->line('confirm'); ?></button>
					</footer>
				</form>
			</div>
			<div class="col-xs-12 col-sm-12 col-md-6 col-lg-6 d-none">
			    <?php if (checkUserPermessions(getUserId()) == true && $user->userLevel == 3) { ?>
					<div class="jarviswidget jarviswidget-color-orange" id="wid-id233323-3" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false" data-widget-fullscreenbutton="false" data-widget-custombutton="false" data-widget-collapsed="false" data-widget-sortable="false">
						<header>
							<span class="widget-icon"> <i class="fa fa-dollar"></i> </span>
							<h2 style="margin-right: 10px;"><?php echo $this->lang->line('permissions'); ?></h2>
						</header>
						<div>

							<div class="table-responsive">
								<table class="table table-bordered table-striped">
									<thead>
										<th></th>
										<th colspan="2"><?php echo $this->lang->line('name'); ?></th>
										<th>#</th>
									</thead>

								</table>
							</div>

						</div>
					</div>
				<?php }; ?>
				<?php if (checkUserPermessions(getUserId()) == true && ($user->userLevel == 1 || $user->userLevel == 2  || $user->userLevel == 4)) { ?>
					<div class="col-xs-12 col-sm-12 col-md-6 col-lg-6">
						<div class="jarviswidget jarviswidget-color-orange" id="wid-id233323-3" data-widget-editbutton="false" data-widget-colorbutton="false" data-widget-deletebutton="false" data-widget-fullscreenbutton="false" data-widget-custombutton="false" data-widget-collapsed="false" data-widget-sortable="false">
							<header>
								<span class="widget-icon"> <i class="fa fa-dollar"></i> </span>
								<h2 style="margin-right: 10px;"><?php echo $this->lang->line('permissions'); ?></h2>
							</header>
							<div>
								<div class="jarviswidget-editbox"></div>
								<div class="widget-body no-padding">
									<br />
									<div class="btn-group" role="group">
										<?php foreach ($permessions_array as $key => $value) { ?>
											<button type="button" class="filter_permissions btn btn-success btn-sm" rel="<?php echo $key; ?>"><?php echo strtoupper($key); ?></button>
										<?php }; ?>
										<button type="button" class="filter_permissions btn btn-warning btn-sm" rel="show_all"><?php echo $this->lang->line('show_all'); ?></button>
									</div>
									<br />
									<br />
									<div class="table-responsive">
										<table class="table table-bordered table-striped" id="permissions_table">
											<thead>
												<th width="50%"><?php echo $this->lang->line('name'); ?></th>
												<th>#</th>
											</thead>
											<tbody>
												<?php foreach ($permessions_array as $key => $value) { ?>
													<tr rel="<?php echo $key; ?>">
														<td colspan="2">
															<strong><?php echo $key; ?></strong>
														</td>
													</tr>
													<tr rel="<?php echo $key; ?>" class="highlight">
														<td></td>
														<td class="smart-form">
															<label class="toggle">
																<p><?php echo $this->lang->line('activation_freezing_manner'); ?></p>
																<input type="checkbox" class="permessions_admin_main" rel-type="<?php echo $key; ?>" <?php if (in_array(1, $value)) {
																																							echo 'checked="checked"';
																																						}; ?>>
																<i data-swchon-text="ON" data-swchoff-text="OFF"></i>
															</label>
														</td>
													</tr>
													<?php foreach ($value as $k => $v) { ?>
														<tr rel="<?php echo $key; ?>">
															<td>
																<?php if (isset($sub_permessions_array[$key][$k])) { ?>
																	<a href="#0" class="btn-link show_sub" rel-sub="<?php echo $key; ?>-<?php echo $k; ?>">
																		<strong><?php echo $k; ?></strong>
																	</a>
																<?php } else { ?>
																	<?php echo $k; ?>
																<?php }; ?>
															</td>
															<td class="smart-form">
																<label class="toggle">
																	<input type="checkbox" class="permessions_admin" rel-type="<?php echo $key; ?>" rel-text="<?php echo $k; ?>" <?php if ($v == 1) {
																																														echo 'checked="checked"';
																																													}; ?>>
																	<i data-swchon-text="ON" data-swchoff-text="OFF"></i>
																</label>
															</td>
														</tr>
														<?php if (isset($sub_permessions_array[$key][$k])) { ?>
															<tr class="sub_permission highlight" rel="<?php echo $key; ?>-<?php echo $k; ?>">
																<td></td>
																<td class="smart-form">
																	<label class="toggle">
																		<p><?php echo $this->lang->line('activation_freezing_manner'); ?></p>
																		<input type="checkbox" class="sub_permessions_admin_main" rel-type="<?php echo $key; ?>" rel-sub="<?php echo $k; ?>" <?php if (in_array(1, $sub_permessions_array[$key][$k])) {
																																																	echo 'checked="checked"';
																																																}; ?>>
																		<i data-swchon-text="ON" data-swchoff-text="OFF"></i>
																	</label>
																</td>
															</tr>
															<?php foreach ($sub_permessions_array[$key][$k] as $ke => $va) { ?>
																<tr class="sub_permission" rel="<?php echo $key; ?>-<?php echo $k; ?>">
																	<td class="sub_cell"><?php echo $ke; ?></td>
																	<td class="smart-form">
																		<label class="toggle">
																			<input type="checkbox" class="permessions_admin" rel-type="<?php echo $key; ?>" rel-parent="<?php echo $k; ?>" rel-text="<?php echo $ke; ?>" <?php if ($va == 1) {
																																																								echo 'checked="checked"';
																																																							}; ?>>
																			<i data-swchon-text="ON" data-swchoff-text="OFF"></i>
																		</label>
																	</td>
																</tr>
															<?php }; ?>
														<?php }; ?>
													<?php }; ?>
													<tr>
														<td colspan="2"></td>
													</tr>
												<?php }; ?>
											</tbody>
										</table>
									</div>
								</div>
							</div>
						</div>
					</div>
				<?php }; ?>
			</div>
		</div>
	</div>

	<script>
		$(document).ready(function() {
			$(document).on('change', '.permession', function() {
				var data = {};
				data.type = $(this).attr("rel-type");
				data.text = $(this).attr("rel-text");
				data.per = $(this).is(':checked') ? 1 : 0;
				data.userId = "<?php echo $user->userId; ?>";

				$.post(root + 'admin/users/updateUserPermession', data, function(d) {
					if (d.result == true) {
						var a = getResult(type = 'success');
					} else {
						var a = getResult(type = 'failed');
					}
				}, 'json');
			});
			$(document).on('click', '.filter_permissions', function() {
				var type = $(this).attr("rel");
				if (type == 'show_all') {
					$('#permissions_table tbody tr').show();
				} else {
					$('#permissions_table tbody tr').hide();
					$('#permissions_table tbody tr[rel="' + type + '"]').show();
				}
			});
			$(document).on('change', '.permessions_admin', function() {
				var data = {};
				data.type = $(this).attr("rel-type");
				data.text = $(this).attr("rel-text");
				data.per = $(this).is(':checked') ? 1 : 0;
				data.userId = "<?php echo $user->userId; ?>";
				$.post(root + 'admin/users/updateAdminsPermession', data, function(d) {
					if (d.result == true) {
						var a = getResult(type = 'success');
					} else {
						var a = getResult(type = 'failed');
					}
				}, 'json');
			});
			$(document).on('change', '.permessions_admin_main', function() {
				var data = {};
				data.type = $(this).attr("rel-type");
				data.per = $(this).is(':checked') ? 1 : 0;
				data.userId = "<?php echo $user->userId; ?>";
				$.post(root + 'admin/users/updateAdminsPermessionMain', data, function(d) {
					if (d.result == true) {
						var a = getResult(type = 'success');
						$('.permessions_admin[rel-type="' + data.type + '"]').prop('checked', data.per);
					} else {
						var a = getResult(type = 'failed');
					}
				}, 'json');
			});
			$(document).on('change', '.sub_permessions_admin_main', function() {
				var data = {};
				data.type = $(this).attr("rel-type");
				data.sub = $(this).attr("rel-sub");
				data.per = $(this).is(':checked') ? 1 : 0;
				data.userId = "<?php echo $user->userId; ?>";
				$.post(root + 'admin/users/updateAdminsSubPermessionMain', data, function(d) {
					if (d.result == true) {
						var a = getResult(type = 'success');
						$('.permessions_admin[rel-parent="' + data.sub + '"]').prop('checked', data.per);
					} else {
						var a = getResult(type = 'failed');
					}
				}, 'json');
			});
			$(document).on('click', '.show_sub', function() {
				var rel = $(this).attr("rel-sub");
				$('tr[rel="' + rel + '"]').toggle();
			});
		});

		function changeUserPassword(userId) {
			if (confirm('<?php echo $this->lang->line('password_sent_email'); ?>')) {
				$.post(root + 'admin/users/changeUserPassword/' + userId, {}, function() {
					window.location.reload();
				});
			}
		}
	</script>