<?php

class general_model extends CI_Model {

    function __construct() {
        parent::__construct();
    }
    
    function insertRow($tableName, $data) {
        $result = $this->db->insert($tableName, $data);
        if ($result) {
                return $this->db->insert_id();
        } else {
                return false;
        }
    }
    
    function getTableWhere($table, $column, $Id, $isActive = true) {
        
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where($column, $Id);
        //$this->db->where('IsActive', $isActive);
        $query = $this->db->get();
        
	return $query->result();
    }
    
    function getTable($table) {
        
        $this->db->select('*');
        $this->db->from($table);
        $query = $this->db->get();
        
		return $query->result();
    }
    
    function getRowById($table, $column, $Id) {
        
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where($column, $Id);
        $query = $this->db->get();
        
		return $query->row();
    }

    function getTableWhereArray($table, $whereArray) {
        
        $this->db->select('*');
        $this->db->from($table);
        foreach($whereArray as $key => $val) {
            $this->db->where($key, $val);    
        }        
        $query = $this->db->get();
        
	   return $query->result();
    }
    
    function updateRowById($tableName, $column, $id, $data) {
		$this->db->where($column, $id);
        return $this->db->update($tableName, $data);
	}
    
    function updateRowByArray($tableName, $column1, $column2, $where1, $where2, $data) {
		$this->db->where($column1, $where1);
        $this->db->where($column2, $where2);
        $this->db->set($data);
        return $this->db->update($tableName);
	}
    function updateStatus($id, $column, $table, $statusCol, $status) {
        $this->db->where($column, $id);
        $this->db->set($statusCol, $status);
        return $this->db->update($table);
    }
    
    function getUserTypes() {
        $this->db->select('*');
        $this->db->from('user_types');
        $query = $this->db->get();
        
		return arrayToObject($query->result());  
    }
    
    function countRowsByName($table, $cName, $value) {
        $query = $this->db->get_where($table, array($cName => $value));
        return $query->num_rows();                 
    }
    
    function countRowsByNameByAdmin($table, $cName, $value, $adminId) {
        $this->db->select('*');
        $this->db->from($table);
        $this->db->where($cName, $value);
        $this->db->where('adminId', $adminId);
        
        $query = $this->db->get();
        return $query->num_rows();                 
    }
    
    function getLeadStatuses() {
        $this->db->select('*');
        $this->db->from('lead_statuses');
        $this->db->order_by('lsId', 'ASC');
        $query = $this->db->get();
        
		return $query->result();  
    }
    
    function getCountByColumn($table, $column, $value = null) {
        
        $this->db->select('*');
        $this->db->from($table);
        if($value != null) $this->db->where($column, $value);
        $query = $this->db->get();
        
		return $query->num_rows();
    }
    
    function getUserCountry($location) {
        $this->db->select('country');
        $this->db->from('ip_to_country');
        $this->db->where('ipStart <' ,$location);
        $this->db->where('ipEnd >' ,$location);
        $query = $this->db->get();
        
		return $query->result();  
    }
    
    function getCustomersTree() {

        $this->db->select('*');
        $this->db->from('customers');
        $this->db->where('parentId', 1);
        $this->db->where('isActive', 1);
        $this->db->where('customerId !=', 1);
        $query = $this->db->get();
        
		$mainCats = $query->result();
        
        foreach($mainCats as $mc) {
            $mainCatsFinal[$mc->customerId] = $mc;
            
            $this->db->select('*');
            $this->db->from('customers');
            $this->db->where('parentId', $mc->customerId);
            $this->db->where('isActive', 1);
            $query = $this->db->get();
            
    		$subCats = $query->result();
            $subCatsFinal = array();
            foreach($subCats as $sc) {
                $subCatsFinal[$sc->customerId] = $sc;
            }
             
            $subCatsF[$mc->customerId] = $subCatsFinal;
        }
        
        $customers = array($mainCatsFinal, $subCatsF);
        return $customers;
    }    
           
}