<style>
    body {
        background: rgb(204, 204, 204);
    }

    page {
        background: white;
        display: block;
        margin: 0 auto;
        margin-bottom: 0.5cm;
        box-shadow: 0 0 0.5cm rgba(0, 0, 0, 0.5);
    }

    page[size="A4"] {
        width: 21cm;
        height: 29.7cm;
        padding: 25px;
        padding-top: 20px;
        overflow-y: scroll;
    }

    .col {
        text-align: center;
    }

    table.table.table-condensed tr td:nth-child(2) {
        font-weight: bold;
    }

    table.table.table-condensed td {
        border-top: 0px !Important;
        padding: 0px;
    }

    #invoice_table {
        text-align: right;
    }

    #invoice_table tfoot td:nth-child(2) {
        text-align: left;
        font-weight: bold;
    }

    #invoice_table tfoot td:nth-child(3) {
        font-weight: bold;
    }


    #invoice_table tfoot tr:nth-last-child(1) td:nth-child(3),
    #invoice_table tfoot tr:nth-last-child(1) td:nth-child(2) {
        background: #f1f1f1;
    }

    #invoice_table,
    #payment_table {
        border: 1px solid #dedede;
        text-align: right !important;
    }

    #payment_table tfoot {
        font-weight: bold;
    }

    #payment_table tfoot tr td:nth-child(3),
    #payment_table tfoot tr td:nth-child(2) {
        background: #f1f1f1;
    }
</style>

<div id="main" role="main">
    <div id="content">
        <page size="A4">
            <form action="<?php echo site_url(); ?>admin/invoices/createInvoiceOnlySupplier" method="POST" id="createInvoiceForm" autocomplete="OFF">
                <div class="row">
                    <div class="col col-lg-12 col-md-12 col-sm-12">
                        <h2>
                        <?php echo $this->lang->line('invoicing_tax'); ?>

                        </h2>
                    </div>
                    <div class="col-lg-6 col-md-12 col-sm-12" id="customer_details">
                        <table class="table table-sm">
                            <tbody>
                                <tr class="main_row">
                                    <td>
                                        <?php echo $this->lang->line('send_to'); ?>
                                    </td>
                                    <td style=" width: 200px; ">
                                        <select name="invoice_for" class="select2" id="invoice_for">
                                            <optgroup class="companies_list_from" label="<?php echo $this->lang->line('suppliers'); ?>">
                                                <option value=""><?php echo $this->lang->line('select2'); ?></option>
                                                <?php foreach ($suppliers as $supplier) { ?>
                                                    <option value="<?php echo $supplier->supplier_id; ?>"><?php echo $supplier->name; ?></option>
                                                <?php }; ?>
                                            </optgroup>
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2" class="details" id="customer_phone_number"></td>
                                </tr>
                                <tr>
                                    <td colspan="2" class="details" id="customer_address"></td>
                                </tr>
                                <tr>
                                    <td colspan="2" class="details" id="customer_email"></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="col-lg-6 col-md-12 col-sm-12" id="main_invoice_details">
                        <table class="table table-sm">
                            <tbody>
                                <tr>
                                <td><?php echo $this->lang->line('date'); ?></td>
                                    <td>
                                        <input type="text" value="" name="invoice_date" class="datepicker form-control" />
                                    </td>
                                </tr>
                                <tr>
                                    <td><?php echo $this->lang->line('supplier_number'); ?></td>
                                    <td class="details" id="customerId"></td>
                                </tr>
                                <tr>
                                    <td><?php echo $this->lang->line('number_deals'); ?></td>
                                    <td class="details" id="customer_inv_id"></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="col col-lg-12 col-md-12 col-sm-12" id="invoice_details">
                        <table class="table" id="invoice_table">
                            <thead>
                            <tr>
                                    <th colspan="3" style=" width: 200px; "><?php echo $this->lang->line('description'); ?></th>
                                    <th><?php echo $this->lang->line('unit'); ?></th>
                                    <th><?php echo $this->lang->line('unit_price'); ?></th>
                                    <th><?php echo $this->lang->line('sum'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr class="items">
                                    <td colspan="3" style="width: 60%;">
                                        <select name="items[description][]" class="select2Custom"></select>
                                    </td>
                                    <td>
                                        <input type="text" value="" name="items[unit][]" class="item_unit form-control" />
                                    </td>
                                    <td>
                                        <input type="text" value="" name="items[price][]" class="item_price form-control" />
                                    </td>
                                    <td>
                                        <input type="text" value="" name="items[full_price][]" class="full_price form-control" readonly="readonly" />
                                    </td>
                                </tr>

                                <tr id="btns_group">
                                    <td colspan="6" style="text-align:center;">
                                        <a href="#0" class="btn btn-success btn-circle" id="add_item">
                                            <i class="fa fa-plus"></i>
                                        </a>
                                    </td>
                                </tr>

                            </tbody>
                            <tfoot>
                                <tr>
                                    <td colspan="4"></td>
                                    <td><?php echo $this->lang->line('total_before_vat'); ?></td>
                                    <td><input type="text" value="0" name="total_before_vat" id="total_before_vat" class="form-control" readonly /></td>
                                </tr>
                                <tr>
                                    <td colspan="4"></td>
                                    <td><?php echo $this->lang->line('vat_17'); ?></td>
                                    <td>
                                        <input type="text" value="0" name="vat" id="vat" class="form-control" readonly />
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="4"></td>
                                    <td><?php echo $this->lang->line('total_shekel'); ?></td>
                                    <td><input type="text" value="0" name="total" id="total" class="form-control" readonly /></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    <div class="col col-lg-12 col-lg-12 col-sm-12">
                        <div class="row">
                            <div class="col-lg-4"></div>
                            <div class="col-lg-4"></div>
                            <div class="col-lg-4">
                                <a href="#0" class="btn btn-success btn-block" id="save_invoice">
                                <?php echo $this->lang->line('invoicing_save'); ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </page>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-default" data-bs-dismiss="modal"><?php echo $this->lang->line('close'); ?></button>
</div>




<style>
    ul.select2-result-sub {
        padding-right: 5px !important;
    }

    .select2-result-sub li {
        border-right: 4px solid #dadada;
    }

    .select2-results li.select2-result-with-children>.select2-result-label {
        font-weight: bold;
        background: #F44336;
        color: white;
    }

    .remove_this_item,
    .remove_this_payment {
        position: absolute;
        right: 0px;
        margin-top: 10px;
    }

    .remove_this_item:active,
    .remove_this_payment:active {
        position: absolute;
        top: auto !important;
        left: auto !important;
        right: 0px !important;
    }
</style>

<script type="text/javascript">
    $(document).ready(function() {

        var total_before_vat = 0;
        var vat = 0;
        var total = 0;

        $('.datepicker').datepicker({
            dateFormat: "dd/mm/yy",
            isRTL: true,
            prevText: '<i class="fa fa-chevron-left"></i>',
            nextText: '<i class="fa fa-chevron-right"></i>',
        });

        $('#add_item').on('click', function() {
            var $table = $('#invoice_table');
            var new_line = $table.find('tr.items').first().clone();
            new_line.find(".item_description").val("");
            new_line.find(".item_unit").val("");
            new_line.find(".item_price").val("");
            new_line.find(".full_price").val("");
            new_line.append('<a href="#0" class="remove_this_item btn bg-danger btn-sm text-white"><i class="fa fa-times"></i></a>');
            new_line.insertBefore('#btns_group');
            calcTotal();
        });

        $('#add_payment_line').on('click', function() {
            var $table = $('#payment_table');
            var new_line = $table.find('tr.payments').first().clone();
            new_line.find("input.total_payment").val("");
            new_line.append('<a href="#0" class="remove_this_payment btn bg-danger btn-xs text-white"><i class="fa fa-times"></i></a>');
            new_line.insertBefore('#btns_group_payments');
        });


        $(document).on('click', '.remove_this_item', function() {
            $(this).parent().remove();
            calcTotal();
        });


        $('#save_invoice').on('click', function() {
            $('#createInvoiceForm').submit();
        });

        $('#invoice_for').on('change', function() {
            var data = {};
            data.supplier_id = $(this).val();
            $.post(root + 'admin/invoices/getSupplierDetailsforInvoice', data, function(d) {

                if (d.result == true) {
                    $('#customer_phone_number').html(d.phone_number);
                    $('#customer_address').html(d.address);
                    $('#customer_email').html(d.email);
                    $('#customerId').html(d.supplier_id);
                    $('#customer_inv_id').html(d.vat_number);
                } else {
                    $('#customer_phone_number').html("");
                    $('#customer_address').html("");
                    $('#customer_email').html("");
                    $('#customerId').html("");
                    $('#customer_inv_id').html("");
                }

            }, 'json');
        });

        $(document).on('change', '.item_price', function() {
            calcTotal();
        });

        $(document).on('change', '.item_unit', function() {
            calcTotal();
        });
        $(document).on('change', '.select2Custom', function() {
            var elem = $(this);
            var data = {};
            data.id = $(this).val();
            $.post(root + 'admin/invoices/getItemPrice', data, function(d) {
                if (d.price) {
                    elem.parent().parent().find('.item_price').val(d.price);
                    calcTotal();
                }
            }, 'json');
        });

        function calcTotal() {
            var full_total = 0;
            $(".item_price").each(function(index) {
                var elem = $(this);
                var price = Number(elem.val());
                var unit = Number(elem.parent().parent().find('.item_unit').val());
                var priceF = price * unit;
                elem.parent().parent().find('.full_price').val(priceF);
                full_total = full_total + priceF;
            });
            var before_vat = full_total / 1.17;
            var vat = full_total - before_vat;
            $('#total_before_vat').val(before_vat.toFixed(2));
            $('#vat').val(vat.toFixed(2));
            $('#total').val(full_total.toFixed(2));
        }
    });
</script>

<style>
    #customer_details .table tr td:empty {
        display: none;
    }
</style>