<div id="main" role="main">
    <div id="content" style=" padding-top: 0px; ">
        <div class="row mt-3">
            <div class="col-lg-6">
                <h1><?php echo $this->lang->line('warehouses_transfer'); ?></h1>
            </div>
            <div class="col-lg-6 text-align-right">
                <div class="btn-group">
                    <button type="button" class="btn btn-info btn-lg" data-bs-toggle="modal" data-bs-target="#myModal"><?php echo $this->lang->line('new_transfer'); ?></button>
                </div>
            </div>
            <div class="col-lg-12">
                <hr />
            </div>
            <div class="col col-lg-12 table-responsive">
                <div class="card card-body">
                    <table class="table table-bordered" id="dt_basic2">
                        <thead>
                            <th><?php echo $this->lang->line('documentary'); ?></th>
                            <th><?php echo $this->lang->line('date'); ?></th>
                            <th><?php echo $this->lang->line('from_warehouse'); ?></th>
                            <th><?php echo $this->lang->line('to_warehouse'); ?></th>
                            <th><?php echo $this->lang->line('total'); ?></th>
                            <th><?php echo $this->lang->line('items'); ?></th>
                            <th><?php echo $this->lang->line('notes'); ?></th>
                        </thead>
                        <tbody>
                            <?php foreach ($warehousesTransfer as &$wt) { ?>
                                <tr>
                                    <td><?php echo $wt->id; ?></td>
                                    <td><?php echo $wt->dateCreation; ?></td>
                                    <td><?php echo getWarehouseById($wt->from_warehouse); ?></td>
                                    <td><?php echo getWarehouseById($wt->to_warehouse); ?></td>
                                    <td><?php echo $wt->quantity; ?></td>
                                    <td><?php echo getItemNameById($wt->product_id); ?></td>
                                    <td><?php echo $wt->notes ?></td>
                                </tr>
                            <?php }; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal" id="myModal" role="dialog">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-bs-dismiss="modal">&times;</button>
                <h4 class="modal-title w-100"><?php echo $this->lang->line('warehouses_transfer'); ?></h4>
            </div>
            <div class="modal-body">
                <div id="content">
                    <form action="<?php echo site_url(); ?>admin/warehousesTransfer/transferWarehouse" method="POST" id="warehouse_transfer" autocomplete="OFF">
                        <div class="first-stage">
                            <div class="form-header">
                                <div class="invoice-head">
                                    <label for="">מס העברת</label>
                                    <input class="form-control" value="<?php print getWarehousesTransferNo(); ?>" name="transfer_code" readonly>
                                </div>
                                <div class="tra-head">
                                    <label for=""><?php echo $this->lang->line('date'); ?></label>
                                    <input type="text" value="<?php $now = date('Y-m-d');
                                                                echo date("d/m/Y", strtotime($now)); ?>" name="dateCreation" id="dateCreation" class="datepicker form-control" />
                                </div>
                            </div>
                            <div class="form-full">
                                <label for=""><?php echo $this->lang->line('from_warehouse'); ?></label>
                                <div class="selectorHolder">
                                    <select name="from_warehouse" class="select2 from_warehouse" id="from_warehouse">
                                        <option value=""><?php echo $this->lang->line('select2'); ?></option>
                                        <optgroup class="warehouse_list_from">
                                            <?php foreach ($warehouse as  $house) { ?>
                                                <option value="<?php echo $house->ID; ?>"><?php echo $house->ID; ?>-<?php echo $house->Name; ?></option>
                                            <?php  } ?>
                                        </optgroup>
                                    </select>
                                </div>
                            </div>
                            <div class="form-full">
                                <label for="">למחסן</label>
                                <div class="selectorHolder">
                                    <select name="to_warehouse" class="select2 to_warehouse" id="to_warehouse">
                                        <option value=""><?php echo $this->lang->line('select2'); ?></option>
                                        <optgroup class="warehouse_list_from">
                                            <?php foreach ($warehouse as  $house) { ?>
                                                <option value="<?php echo $house->ID; ?>"> <?php echo $house->ID; ?>-<?php echo $house->Name; ?></option>
                                            <?php  } ?>
                                        </optgroup>
                                    </select>
                                </div>
                            </div>
                            <div class="form-full">
                                <label for="">פריטים</label>
                                <div class="row w-100 d-flex justify-content-end m-0">
                                    <input class="form-control" placeholder="פריטים" name="items" id="items">
                                </div>
                            </div>
                            <div class="form-full">
                                <label for=""><?php echo $this->lang->line('notes'); ?></label>
                                <textarea class="form-control" style="width: 85%;" placeholder="הזן את ההערה שלך" id="notes" name="notes"></textarea>
                            </div>
                            <div class="row w-100 d-flex justify-content-end m-0">
                                <button type="button" class="btn btn-success rounded float-left w-25 p-2 next-stage">
                                    <?php echo $this->lang->line('confirm'); ?>
                                </button>
                            </div>
                            <!-- </form> -->
                        </div>
                        <page size="A4" style="display: none;">
                            <button type="button" class="reverse-stage btn btn-primary p-1"><i class="fas fa-angle-right me-1"></i><?php echo $this->lang->line('back'); ?></button>
                            <div class="second_stage_header row align-items-start">
                                <div class="right-section col-lg-6">
                                    <div class="form-header">
                                        <div class="tra-head">
                                            <label for=""><?php echo $this->lang->line('tranfer_num'); ?></label>
                                            <input class="form-control" value="<?php print getWarehousesTransferNo(); ?>" name="invoice_code" readonly>
                                        </div>
                                        <div class="tra-head">
                                            <label for=""><?php echo $this->lang->line('date'); ?></label>
                                            <input type="text" value="<?php $now = date('Y-m-d');
                                                                        echo date("d/m/Y", strtotime($now)); ?>" name="dateCreation" id="dateCreation" class="form-control" readonly />
                                        </div>
                                    </div>
                                    <div>
                                        <h4><?php echo $this->lang->line('from_warehouse'); ?>: <input type="text" id="myText" name="myText" class="form-control" readonly></h4>
                                        <h4><?php echo $this->lang->line('to_warehouse'); ?>:<input type="text" id="aText" name="aText" class="form-control" readonly></h4>
                                    </div>
                                    <div>
                                        <table class="table table-bordered">
                                            <thead>
                                                <th>#</th>
                                                <th><?php echo $this->lang->line('items'); ?></th>
                                                <th><?php echo $this->lang->line('warehouse_balance'); ?></th>
                                                <th><?php echo $this->lang->line('quantity'); ?></th>
                                            </thead>
                                            <tbody>
                                                <td>1</td>
                                                <td> <select name="product_id" class="select2" id="product_id">
                                                        <option value=""><?php echo $this->lang->line('select2'); ?></option>
                                                        <?php foreach ($products as  $product) { ?>
                                                            <option value="<?php echo $product->id; ?>"><?php echo $product->name; ?></option>
                                                        <?php  }; ?>
                                                    </select></td>
                                                <td><input class="form-control" value="1" name="" readonly></td>
                                                <td><input class="form-control quantity text-center" value="" placeholder="0" name="quantity" id="quantity"></td>
                                            </tbody>
                                        </table>
                                    </div>
                                    <div class="float-md-start">
                                        <h1>
                                            <label>
                                                <?php echo $this->lang->line('total_items_to_supply'); ?>:
                                            </label>
                                            <span id="sum">0</span>
                                        </h1>
                                    </div>
                                </div>
                                <div class="float-md-start my-2">
                                    <a href="#0" class="btn btn-success float-lg-start me-15 my-3 w-25" id="save_transfer">
                                        <?php echo $this->lang->line('confirm'); ?>
                                    </a>
                                </div>
                        </page>
                    </form>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-bs-dismiss="modal"><?php echo $this->lang->line('close'); ?></button>
            </div>
        </div>
    </div>
</div>



<script type="text/javascript">
<?php
            $url = '';
            if( $this->session->userdata('site_lang') == 'hebrew' ){
                $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Hebrew.json';
            }else if( $this->session->userdata('site_lang') == 'arabic' ){
                $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Arabic.json';
            }else if( $this->session->userdata('site_lang') == 'english' ){
                $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json';
            }else{
                $url = '//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Hebrew.json';
            }
        ?>
    $(document).ready(function() {
        var oTbl1 = $('#dt_basic2').DataTable({
            "sDom": "<'dt-toolbar'<'col-xs-12 col-sm-8'f><'dt-buttons col-sm-4 col-xs-12 hidden-xs'l>r>" +
                "t" +
                "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-xs-12 col-sm-6'p>>",
            "buttons": ['copyHtml5', 'excelHtml5', 'csvHtml5', 'colvis'],
            "processing": true,
            "bStateSave": true,
            "dom": 'Blfrtip',
            "pagingType": "full_numbers",
            "lengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "<?php echo $this->lang->line('Everything'); ?>"]
            ],
            "pageLength": 20,
            "sPaginationType": "full_numbers",
            "iDisplayLength": 10,
            "language": {
                    "url": "<?php echo $url; ?>"
                },

            orderCellsTop: true,
            fixedHeader: true
        });
        oTbl1.buttons().container().appendTo('.dataTables_filter');
        $('#from_warehouse').change(function() {
            $('#myText').val($(this).find('option:selected').text());
        });
        $('#to_warehouse').change(function() {
            $('#aText').val($(this).find('option:selected').text());
        });
        $('#myModal').on('hidden.bs.modal', function(e) {
            let elem = $(this);
            elem.find('.first-stage').show();
            elem.find('page').hide();
        });
        $('.reverse-stage').on('click', function() {
            let elem = $(this);
            elem.parent().parent().find('.first-stage').show();
            elem.parent().hide();
        });
        $('.datepicker').datepicker({
            dateFormat: "dd/mm/yy",
            isRTL: true,
            prevText: '<i class="fa fa-chevron-left"></i>',
            nextText: '<i class="fa fa-chevron-right"></i>',
        });
        $(document).on('click', '.next-stage', function() {
            let supplier = $('#invoice_for').find('option:selected').text();
            let date = $("#invoice_date").val();
            let comment = $("#cust_Comment").val();
            let elem = $(this);
            elem.parent().parent().parent().find('page').show();
            $("#supplier").html(supplier);
            $("#customer_comment").val(comment);
            $("#invoice_date1").val(date);
            elem.parent().parent().hide();

            $('#product_id').select2({
                placeholder: '<?php echo $this->lang->line('Look_for_items'); ?>',
                selectOnClose: false,
                tags: true,
                dropdownParent: $('#myModal'),
                ajax: {
                    dataType: "json",
                    url: root + 'admin/invoices/getItems',
                    processResults: function(data) {
                        return {
                            results: data.results
                        }
                    }
                },
                "language": {
                    "noResults": function() {
                        return "<?php echo $this->lang->line('Look_for_items'); ?>";
                    }
                },
                theme: "bootstrap-5"
            });
        });
        $('#DeleteInvoice').on('hidden.bs.modal', function(e) {
            let elem = $(this);
            elem.find('.first-stage').show();
            elem.find('page').hide();
        });
        $('#myModal').on('hidden.bs.modal', function(e) {
            let elem = $(this);
            elem.find('.first-stage').show();
            elem.find('page').hide();
        });
        $('.reverse-stage').on('click', function() {
            let elem = $(this);
            elem.parent().parent().find('.first-stage').show();
            elem.parent().hide();
        });
        $('#save_transfer').on('click', function() {
            $('#warehouse_transfer').submit();
        });
        $("#quantity").each(function() {

            $(this).keyup(function() {
                calculateSum();
            });
        });
    });

    function calculateSum() {

        var sum = 0;
        //iterate through each textboxes and add the values
        $(".quantity").each(function() {

            //add only if the value is number
            if (!isNaN(this.value) && this.value.length != 0) {
                sum += parseFloat(this.value);
            }

        });
        //.toFixed() method will roundoff the final sum to 2 decimal places
        $("#sum").html(sum.toFixed(0));
    }
</script>
<style>
    #customer_details .table tr td:empty {
        display: none;
    }

    .cron-container .select2-search:before {
        display: none !important;
    }
</style>