<!DOCTYPE html>
<html lang="en-us" dir="rtl" lang="ar">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <title> <?php print $title ?> </title>
    <meta name="description" content="">
    <meta name="keywords" content="">
    <meta name="robots" content="noindex, nofollow">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <link rel="stylesheet" href="//cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.rtl.min.css" integrity="sha384-gXt9imSW0VcJVHezoNQsP+TNrjYXoGcrqBZJpry9zJt8PCQjobwmhMGaDHTASo9N" crossorigin="anonymous">
    <link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/fontawesome.min.css" integrity="sha512-OdEXQYCOldjqUEsuMKsZRj93Ht23QRlhIb8E/X0sbwZhme8eUw6g8q7AdxGJKakcBbv7+/PX0Gc2btf7Ru8cZA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/brands.min.css" integrity="sha512-apX8rFN/KxJW8rniQbkvzrshQ3KvyEH+4szT3Sno5svdr6E/CP0QE862yEeLBMUnCqLko8QaugGkzvWS7uNfFQ==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/solid.min.css" integrity="sha512-jQqzj2vHVxA/yCojT8pVZjKGOe9UmoYvnOuM/2sQ110vxiajBU+4WkyRs1ODMmd4AfntwUEV4J+VfM6DkfjLRg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <!-- <link rel="stylesheet" href="//cdn.datatables.net/1.10.25/css/dataTables.bootstrap5.min.css"> -->
    <link rel="stylesheet" href="<?php echo site_url(); ?>assets/css/dashboard.css">
    <!-- <link rel="stylesheet" href="<?php echo site_url(); ?>assets/css/smartadmin-rtl.min.css">
    <link rel="stylesheet" href="<?php echo site_url(); ?>assets/css/smartadmin-production.css"> -->
    <link rel="stylesheet" href="//cdn.datatables.net/1.10.25/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="//cdn.datatables.net/buttons/1.7.1/css/buttons.bootstrap5.min.css">
    <link rel="stylesheet" href="//cdn.datatables.net/datetime/1.1.0/css/dataTables.dateTime.min.css">
    <link rel="stylesheet" href="//cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css" />
    <link rel="stylesheet" href="//cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.1.1/dist/select2-bootstrap-5-theme.min.css" />
    <link rel="stylesheet" href="<?php echo site_url(); ?>assets/css/custom.css">
    <link rel="shortcut icon" href="<?php echo site_url(); ?>favicon.ico" type="image/x-icon">
    <link rel="icon" href="<?php echo site_url(); ?>favicon.ico" type="image/x-icon">
    <link rel="preconnect" href="//fonts.googleapis.com">
    <link rel="preconnect" href="//fonts.gstatic.com" crossorigin>
    <link href="//fonts.googleapis.com/css2?family=Varela+Round&display=swap" rel="stylesheet">
    <script src="//ajax.googleapis.com/ajax/libs/jquery/2.0.2/jquery.min.js"></script>
    <script src="//ajax.googleapis.com/ajax/libs/jqueryui/1.10.3/jquery-ui.min.js"></script>
    <script>
        var root = '<?php echo site_url(); ?>';
    </script>
    <style>
        input.item_desc {
            min-width: 16rem;
        }
        .select2-container--bootstrap-5 {
            width: 100% !important;
        }
        #invoice_details .select2Custom {
            width: 150px !important;
            max-width: 150px !important;
        }
        #invoice_details .select2-container--bootstrap-5 .select2-selection--single {
            padding: 7px;
            font-size: 10px;
            width: 150px;
            background-position: left .75rem center;
        }
        
        #invoice_details li.select2-results__option {
            font-size: 12px !important;
            padding: 8px !important;
            padding-right: 15px !important;
        }
        
        #invoice_details li.select2-results__option {
            font-size: 12px !important;
            padding: 8px !important;
            padding-right: 15px !important;
            white-space:nowrap;
            overflow: hidden !important;
            text-overflow: ellipsis !important;
        }
        

        @media screen and (max-width: 670px) {
            #invoice_details input {
                min-width:100px;
            }
        
            page #invoice_details {
                overflow-x: auto !important;
                -webkit-overflow-scrolling: auto !important;
            }
        }
        
        @media screen and (max-width: 768px) {
 
            input {
                padding-left: 2px !important;
                padding-right: 2px !important;
                font-size: 10px !important;
            }
            
            input.item_desc {
                min-width: 100px;
            }
            
            .select2Custom {
                max-width: 150px !important;
            }
            .select2-container--bootstrap-5 .select2-selection--single {
                padding: 7px;
                font-size: 10px;
                width: 150px;
                background-position: left .75rem center;
            }
            
            li.select2-results__option {
                font-size: 12px !important;
                padding: 8px !important;
                padding-right: 15px !important;
            }
            page .container-sm {
                max-width: 100%;
            }
            input.full_price, input.item_price {
                width: 60px !important;
            }
            page thead {
                white-space: nowrap;
            }
        }
    </style>
</head>

<body class="smart-rtl">
    <div class="container-fluid">
        <div class="row">
            <?php require_once('adminNav.php'); ?>
            <?php //require_once('adminMenu.php'); 
            ?>
            <main class="col-12 px-md-4">
                <?php echo $body; ?>
            </main>
        </div>
    </div>
    <div id='dialog_userLogin' title='User Login' style="display: none;">
        <form method="POST" action="<?php print site_url(); ?>login/verifyLoginAjax" id="login-form" class="smart-form" style="overflow: hidden;">
            <fieldset>
                <section>
                    <label class="label"><?php echo $this->lang->line('email'); ?></label>
                    <label class="input"> <i class="icon-append fa fa-user"></i>
                        <input type="email" name="email" id="email" class="login" />
                        <b class="tooltip tooltip-top-right"><i class="fa fa-user txt-color-teal">
                            </i><?php echo $this->lang->line('enter_mail'); ?></b></label>
                </section>
                <section>
                    <label class="label">סיסמה</label>
                    <label class="input"> <i class="icon-append fa fa-lock"></i>
                        <input type="password" name="password" id="password" class="login" />
                        <b class="tooltip tooltip-top-right">
                            <i class="fa fa-lock txt-color-teal"></i></i><?php echo $this->lang->line('enter_password'); ?> </i></b>
                    </label>
                    <div class="note">
                        <!--<a href="javascript:void(0)">Forgot password?</a>-->
                    </div>
                </section>
            </fieldset>
        </form>
    </div>
    <script src="//cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous"></script>
    <script src="<?php echo site_url(); ?>assets/js/plugin/fullcalendar/moment.js"></script>
    <script src="//cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>
    <script src="//cdn.datatables.net/1.10.25/js/dataTables.bootstrap5.min.js"></script>
    <script src="//cdn.datatables.net/buttons/1.7.1/js/dataTables.buttons.min.js" crossorigin="anonymous"></script>
    <script src="//cdn.datatables.net/buttons/1.7.1/js/buttons.bootstrap5.min.js"></script>
    <script src="//cdn.datatables.net/1.10.25/js/dataTables.bootstrap5.min.js"></script>
    <script src="//cdn.datatables.net/buttons/1.6.1/js/buttons.flash.min.js" crossorigin="anonymous"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js" crossorigin="anonymous"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js" crossorigin="anonymous"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js" crossorigin="anonymous"></script>
    <script src="//cdn.datatables.net/buttons/1.6.1/js/buttons.html5.min.js" crossorigin="anonymous"></script>
    <script src="//cdn.datatables.net/buttons/1.6.1/js/buttons.print.min.js" crossorigin="anonymous"></script>
    <script src="//cdn.datatables.net/buttons/1.6.1/js/buttons.colVis.min.js" crossorigin="anonymous"></script>
    <script src="<?php echo site_url(); ?>assets/js/smartwidgets/jarvis.widget.min.js"></script>
    <script src="//cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.full.min.js"></script>
    <script>
        $(document).ready(function() {
            if (window !== window.parent) {
                $('nav').remove();
            }
            $(".select2").select2({
                theme: "bootstrap-5",
            });
            
            $('select.select2Custom').select2({
                placeholder: '<?php echo $this->lang->line('Look_for_items'); ?>',
                selectOnClose: false,
                tags: true,
                ajax: {
                    dataType: "json",
                    url: root + 'admin/invoices/getItems',
                    processResults: function(data) {
                        return {
                            results: data.results
                        }
                    }
                },
                "language": {
                    "errorLoading": function() {
                        return "<?php echo $this->lang->line('search'); ?>";
                    }
                },
                theme: "bootstrap-5",
                placeholder: '<?php echo $this->lang->line('select'); ?>',
            });
            $(document).on('click', '.change_language', function(){
                var lang = $(this).attr("rel");
                if(lang !== undefined && lang !== ''){
                    $.post(root + 'admin/ajax/setLanguage/' + lang, function(d) {
                        if(d.result){
                            location.reload();
                        }
                    }, 'json');
                }
            });
            // (function checkUserLogged() {
            //     $.post(root + 'login/checkUserLoggedin', {}, function(d) {
            //         if (d.result) {
            //         } else {
            //             $("#dialog_userLogin").dialog({
            //                 autoOpen: false,
            //                 width: 350,
            //                 resizable: true,
            //                 modal: true,
            //                 title: "<div class='widget-header'><h4><i class='fa fa-users'></i> כניסה</h4></div>",
            //                 buttons: [{
            //                         html: "<i class='fa fa-check'></i>&nbsp; אישור",
            //                         "class": "btn btn-primary",
            //                         click: function() {
            //                             var data = {};
            //                             data.email = $('#email.login').val();
            //                             data.password = $('#password.login').val();
            //                             $.post(root + 'login/verifyLoginAjax', data, function(d) {
            //                                 if (d.result) {
            //                                     $('#dialog_userLogin').dialog("close");
            //                                     $.smallBox({
            //                                         title: "מחובר!",
            //                                         //content : "<i class='fa fa-clock-o'></i> <i>2 seconds ago...</i>",
            //                                         color: "#96bf48",
            //                                         iconSmall: "fa fa-thumbs-up bounce animated",
            //                                         timeout: 2500
            //                                     });
            //                                 } else {
            //                                     $.smallBox({
            //                                         title: 'שם משתמש או סיסמה שגויים!',
            //                                         //content : "<i class='fa fa-clock-o'></i> <i>2 seconds ago...</i>",
            //                                         color: "#C46A69",
            //                                         iconSmall: "fa fa-pointer bounce animated",
            //                                         timeout: 2500
            //                                     });
            //                                 }
            //                             }, 'json');
            //                         }
            //                     },
            //                     /*{
            //                                                		html : "<i class='fa fa-times'></i>&nbsp; ביטול",
            //                                                		"class" : "btn btn-default",
            //                                                		click : function() {
            //                                                			$(this).dialog("close");
            //                                                            //window.location.href = root + 'login/logout';
            //                                                		}
            //                                                	}*/
            //                 ]
            //             });
            //             $('#dialog_userLogin').dialog('open');
            //         }
            //     }, 'json');
            //     setTimeout(checkUserLogged, 600000);
            // })();

            $.post(root + 'admin/ajax/setUserOnline', function(d) {}, 'json');
            var idle = false;
            document.querySelector('body').addEventListener('mousemove', function(e) {
                if (idle != false) idle = false;
            });
            document.querySelector('body').addEventListener('touchmove', function(e) {
                if (idle != false) idle = false;
            });
            var idleI = setInterval(function() {
                var data = {};
                if (idle == 'inactive') {
                    return;
                }
                if (idle == true) {
                    $.post(root + 'admin/ajax/setUserOffline', data, function(d) {

                    }, 'json');
                    idle = 'inactive';
                    return;
                } else {
                    $.post(root + 'admin/ajax/setUserOnline', data, function(d) {

                    }, 'json');
                }
                idle = true;
            }, 60000);
        });
    </script>
</body>

</html>